/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.SelectItem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AllColumns
extends SelectItem {
    private final List<Identifier> aliases;
    private final Optional<Expression> target;

    public AllColumns() {
        this(Optional.empty(), Optional.empty(), (List<Identifier>)ImmutableList.of());
    }

    public AllColumns(Expression target) {
        this(Optional.empty(), Optional.of(target), (List<Identifier>)ImmutableList.of());
    }

    public AllColumns(Expression target, List<Identifier> aliases) {
        this(Optional.empty(), Optional.of(target), aliases);
    }

    public AllColumns(NodeLocation location, Optional<Expression> target, List<Identifier> aliases) {
        this(Optional.of(location), target, aliases);
    }

    public AllColumns(Optional<NodeLocation> location, Optional<Expression> target, List<Identifier> aliases) {
        super(location);
        this.aliases = ImmutableList.copyOf((Collection)Objects.requireNonNull(aliases, "aliases is null"));
        this.target = Objects.requireNonNull(target, "target is null");
    }

    public List<Identifier> getAliases() {
        return this.aliases;
    }

    public Optional<Expression> getTarget() {
        return this.target;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAllColumns(this, context);
    }

    public List<Node> getChildren() {
        return (List)this.target.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllColumns other = (AllColumns)o;
        return Objects.equals(this.aliases, other.aliases) && Objects.equals(this.target, other.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aliases, this.target);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.target.ifPresent(value -> builder.append(value).append("."));
        builder.append("*");
        if (!this.aliases.isEmpty()) {
            builder.append(" (");
            Joiner.on((String)", ").appendTo(builder, this.aliases);
            builder.append(")");
        }
        return builder.toString();
    }
}

