/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import io.prestosql.execution.buffer.PagesSerdeFactory;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.OutputFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class NullOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private boolean finished;

    public NullOutputOperator(OperatorContext operatorContext) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return true;
    }

    @Override
    public void addInput(Page page) {
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class NullOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;

        public NullOutputOperatorFactory(int operatorId, PlanNodeId planNodeId) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, NullOutputOperator.class.getSimpleName());
            return new NullOutputOperator(operatorContext);
        }

        @Override
        public void noMoreOperators() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new NullOutputOperatorFactory(this.operatorId, this.planNodeId);
        }
    }

    public static class NullOutputFactory
    implements OutputFactory {
        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
            return new NullOutputOperatorFactory(operatorId, planNodeId);
        }
    }
}

