/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.relational;

import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.PrestoException;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import io.prestosql.sql.relational.SpecialForm;
import io.prestosql.sql.relational.VariableReferenceExpression;
import java.util.Objects;

public class DeterminismEvaluator {
    private final Metadata metadata;

    public DeterminismEvaluator(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public boolean isDeterministic(RowExpression expression) {
        return expression.accept(new Visitor(this.metadata), null);
    }

    private static class Visitor
    implements RowExpressionVisitor<Boolean, Void> {
        private final Metadata metadata;

        public Visitor(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public Boolean visitInputReference(InputReferenceExpression reference, Void context) {
            return true;
        }

        @Override
        public Boolean visitConstant(ConstantExpression literal, Void context) {
            return true;
        }

        @Override
        public Boolean visitCall(CallExpression call, Void context) {
            ResolvedFunction resolvedFunction = call.getResolvedFunction();
            if (!this.isDeterministic(resolvedFunction)) {
                return false;
            }
            return call.getArguments().stream().allMatch(expression -> expression.accept(this, context));
        }

        private boolean isDeterministic(ResolvedFunction resolvedFunction) {
            try {
                return this.metadata.getFunctionMetadata(resolvedFunction).isDeterministic();
            }
            catch (PrestoException ignored) {
                return true;
            }
        }

        @Override
        public Boolean visitSpecialForm(SpecialForm specialForm, Void context) {
            return specialForm.getArguments().stream().allMatch(expression -> expression.accept(this, context));
        }

        @Override
        public Boolean visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda.getBody().accept(this, context);
        }

        @Override
        public Boolean visitVariableReference(VariableReferenceExpression reference, Void context) {
            return true;
        }
    }
}

