/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.util.Failures;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TopNNode
extends PlanNode {
    private final PlanNode source;
    private final long count;
    private final OrderingScheme orderingScheme;
    private final Step step;

    @JsonCreator
    public TopNNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="count") long count, @JsonProperty(value="orderingScheme") OrderingScheme orderingScheme, @JsonProperty(value="step") Step step) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count must be positive");
        Failures.checkCondition(count <= Integer.MAX_VALUE, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ORDER BY LIMIT > %s is not supported", Integer.MAX_VALUE);
        Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.source = source;
        this.count = count;
        this.orderingScheme = orderingScheme;
        this.step = Objects.requireNonNull(step, "step is null");
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @JsonProperty(value="count")
    public long getCount() {
        return this.count;
    }

    @JsonProperty(value="orderingScheme")
    public OrderingScheme getOrderingScheme() {
        return this.orderingScheme;
    }

    @JsonProperty(value="step")
    public Step getStep() {
        return this.step;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTopN(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TopNNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.count, this.orderingScheme, this.step);
    }

    public static enum Step {
        SINGLE,
        PARTIAL,
        FINAL;

    }
}

