/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Node;
import java.util.List;

public class CheckSubqueryNodesAreRewritten
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        PlanNodeSearcher.searchFrom(plan).where(ApplyNode.class::isInstance).findFirst().ifPresent(node -> {
            ApplyNode applyNode = (ApplyNode)node;
            throw this.error(applyNode.getCorrelation(), applyNode.getOriginSubquery());
        });
        PlanNodeSearcher.searchFrom(plan).where(CorrelatedJoinNode.class::isInstance).findFirst().ifPresent(node -> {
            CorrelatedJoinNode correlatedJoinNode = (CorrelatedJoinNode)node;
            throw this.error(correlatedJoinNode.getCorrelation(), correlatedJoinNode.getOriginSubquery());
        });
        return plan;
    }

    private PrestoException error(List<Symbol> correlation, Node originSubquery) {
        Preconditions.checkState((!correlation.isEmpty() ? 1 : 0) != 0, (Object)"All the non correlated subqueries should be rewritten at this point");
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, originSubquery, "Given correlated subquery is not supported", new Object[0]);
    }
}

