/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class PushDownNegationsExpressionRewriter {
    public static Expression pushDownNegations(Metadata metadata, Expression expression, Map<NodeRef<Expression>, Type> expressionTypes) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata, expressionTypes), (Expression)expression);
    }

    private PushDownNegationsExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Metadata metadata, Map<NodeRef<Expression>, Type> expressionTypes) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        }

        public Expression rewriteNotExpression(NotExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (node.getValue() instanceof LogicalBinaryExpression) {
                LogicalBinaryExpression child = (LogicalBinaryExpression)node.getValue();
                List<Expression> predicates = ExpressionUtils.extractPredicates(child);
                List negatedPredicates = (List)predicates.stream().map(predicate -> treeRewriter.rewrite((Expression)new NotExpression(predicate), (Object)context)).collect(ImmutableList.toImmutableList());
                return ExpressionUtils.combinePredicates(this.metadata, child.getOperator().flip(), negatedPredicates);
            }
            if (node.getValue() instanceof ComparisonExpression && ((ComparisonExpression)node.getValue()).getOperator() != ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                ComparisonExpression child = (ComparisonExpression)node.getValue();
                ComparisonExpression.Operator operator = child.getOperator();
                Expression left = child.getLeft();
                Expression right = child.getRight();
                Type leftType = this.expressionTypes.get(NodeRef.of((Node)left));
                Type rightType = this.expressionTypes.get(NodeRef.of((Node)right));
                Preconditions.checkState((leftType != null && rightType != null ? 1 : 0) != 0, (Object)"missing type for expression");
                if ((this.typeHasNaN(leftType) || this.typeHasNaN(rightType)) && (operator == ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL || operator == ComparisonExpression.Operator.GREATER_THAN || operator == ComparisonExpression.Operator.LESS_THAN_OR_EQUAL || operator == ComparisonExpression.Operator.LESS_THAN)) {
                    return new NotExpression((Expression)new ComparisonExpression(operator, treeRewriter.rewrite(left, (Object)context), treeRewriter.rewrite(right, (Object)context)));
                }
                return new ComparisonExpression(operator.negate(), treeRewriter.rewrite(left, (Object)context), treeRewriter.rewrite(right, (Object)context));
            }
            if (node.getValue() instanceof NotExpression) {
                NotExpression child = (NotExpression)node.getValue();
                return treeRewriter.rewrite(child.getValue(), (Object)context);
            }
            return new NotExpression(treeRewriter.rewrite(node.getValue(), (Object)context));
        }

        private boolean typeHasNaN(Type type) {
            return type instanceof DoubleType || type instanceof RealType;
        }
    }
}

