/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PruneCorrelatedJoinColumns
extends ProjectOffPushDownRule<CorrelatedJoinNode> {
    public PruneCorrelatedJoinColumns() {
        super(Patterns.correlatedJoin());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, CorrelatedJoinNode correlatedJoinNode, Set<Symbol> referencedOutputs) {
        boolean pruned;
        PlanNode input = correlatedJoinNode.getInput();
        PlanNode subquery = correlatedJoinNode.getSubquery();
        if (Sets.intersection((Set)ImmutableSet.copyOf(subquery.getOutputSymbols()), referencedOutputs).isEmpty()) {
            if (correlatedJoinNode.getType() == CorrelatedJoinNode.Type.INNER && QueryCardinalityUtil.isScalar(subquery, context.getLookup()) && correlatedJoinNode.getFilter().equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(input);
            }
            if (correlatedJoinNode.getType() == CorrelatedJoinNode.Type.LEFT && QueryCardinalityUtil.isAtMostScalar(subquery, context.getLookup())) {
                return Optional.of(input);
            }
        }
        Set<Symbol> subquerySymbols = SymbolsExtractor.extractUnique(subquery, context.getLookup());
        List newCorrelation = (List)correlatedJoinNode.getCorrelation().stream().filter(subquerySymbols::contains).collect(ImmutableList.toImmutableList());
        ImmutableSet referencedAndCorrelationSymbols = ImmutableSet.builder().addAll(referencedOutputs).addAll((Iterable)newCorrelation).build();
        if (Sets.intersection((Set)ImmutableSet.copyOf(input.getOutputSymbols()), (Set)referencedAndCorrelationSymbols).isEmpty()) {
            if (correlatedJoinNode.getType() == CorrelatedJoinNode.Type.INNER && QueryCardinalityUtil.isScalar(input, context.getLookup()) && correlatedJoinNode.getFilter().equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(subquery);
            }
            if (correlatedJoinNode.getType() == CorrelatedJoinNode.Type.RIGHT && QueryCardinalityUtil.isAtMostScalar(input, context.getLookup())) {
                return Optional.of(subquery);
            }
        }
        Set<Symbol> filterSymbols = SymbolsExtractor.extractUnique(correlatedJoinNode.getFilter());
        ImmutableSet referencedAndFilterSymbols = ImmutableSet.builder().addAll(referencedOutputs).addAll(filterSymbols).build();
        Optional<PlanNode> newSubquery = Util.restrictOutputs(context.getIdAllocator(), subquery, (Set<Symbol>)referencedAndFilterSymbols);
        ImmutableSet referencedAndFilterAndCorrelationSymbols = ImmutableSet.builder().addAll((Iterable)referencedAndFilterSymbols).addAll((Iterable)newCorrelation).build();
        Optional<PlanNode> newInput = Util.restrictOutputs(context.getIdAllocator(), input, (Set<Symbol>)referencedAndFilterAndCorrelationSymbols);
        boolean bl = pruned = newSubquery.isPresent() || newInput.isPresent() || newCorrelation.size() < correlatedJoinNode.getCorrelation().size();
        if (pruned) {
            return Optional.of(new CorrelatedJoinNode(correlatedJoinNode.getId(), newInput.orElse(input), newSubquery.orElse(subquery), newCorrelation, correlatedJoinNode.getType(), correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery()));
        }
        return Optional.empty();
    }
}

