/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.SetOperationNodeTranslator;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.ExceptNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.NotExpression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ImplementExceptAsUnion
implements Rule<ExceptNode> {
    private static final Pattern<ExceptNode> PATTERN = Patterns.except();
    private final Metadata metadata;

    public ImplementExceptAsUnion(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<ExceptNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ExceptNode node, Captures captures, Rule.Context context) {
        SetOperationNodeTranslator translator = new SetOperationNodeTranslator(this.metadata, context.getSymbolAllocator(), context.getIdAllocator());
        SetOperationNodeTranslator.TranslationResult result = translator.makeSetContainmentPlan(node);
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        List<Expression> presentExpression = result.getPresentExpressions();
        predicatesBuilder.add(Iterables.getFirst(presentExpression, null));
        for (int i = 1; i < presentExpression.size(); ++i) {
            predicatesBuilder.add((Object)new NotExpression(presentExpression.get(i)));
        }
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), result.getPlanNode(), ExpressionUtils.and((Collection<Expression>)predicatesBuilder.build())), Assignments.identity(node.getOutputSymbols())));
    }
}

