/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.OrderBy;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ExpressionRewriteRuleSet {
    private final ExpressionRewriter rewriter;

    public ExpressionRewriteRuleSet(ExpressionRewriter rewriter) {
        this.rewriter = Objects.requireNonNull(rewriter, "rewriter is null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.aggregationExpressionRewrite(), this.filterExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite());
    }

    public Rule<?> projectExpressionRewrite() {
        return new ProjectExpressionRewrite(this.rewriter);
    }

    public Rule<?> aggregationExpressionRewrite() {
        return new AggregationExpressionRewrite(this.rewriter);
    }

    public Rule<?> filterExpressionRewrite() {
        return new FilterExpressionRewrite(this.rewriter);
    }

    public Rule<?> joinExpressionRewrite() {
        return new JoinExpressionRewrite(this.rewriter);
    }

    public Rule<?> valuesExpressionRewrite() {
        return new ValuesExpressionRewrite(this.rewriter);
    }

    private static final class ValuesExpressionRewrite
    implements Rule<ValuesNode> {
        private final ExpressionRewriter rewriter;

        ValuesExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<ValuesNode> getPattern() {
            return Patterns.values();
        }

        @Override
        public Rule.Result apply(ValuesNode valuesNode, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableList.Builder rows = ImmutableList.builder();
            for (List<Expression> row : valuesNode.getRows()) {
                ImmutableList.Builder newRow = ImmutableList.builder();
                for (Expression expression : row) {
                    Expression rewritten;
                    if (!expression.equals((Object)(rewritten = this.rewriter.rewrite(expression, context)))) {
                        anyRewritten = true;
                    }
                    newRow.add((Object)rewritten);
                }
                rows.add((Object)newRow.build());
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new ValuesNode(valuesNode.getId(), valuesNode.getOutputSymbols(), (List<List<Expression>>)rows.build()));
            }
            return Rule.Result.empty();
        }
    }

    private static final class JoinExpressionRewrite
    implements Rule<JoinNode> {
        private final ExpressionRewriter rewriter;

        JoinExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<JoinNode> getPattern() {
            return Patterns.join();
        }

        @Override
        public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
            Optional<Expression> filter = joinNode.getFilter().map(x -> this.rewriter.rewrite((Expression)x, context));
            if (!joinNode.getFilter().equals(filter)) {
                return Rule.Result.ofPlanNode(new JoinNode(joinNode.getId(), joinNode.getType(), joinNode.getLeft(), joinNode.getRight(), joinNode.getCriteria(), joinNode.getLeftOutputSymbols(), joinNode.getRightOutputSymbols(), filter, joinNode.getLeftHashSymbol(), joinNode.getRightHashSymbol(), joinNode.getDistributionType(), joinNode.isSpillable(), joinNode.getDynamicFilters(), joinNode.getReorderJoinStatsAndCost()));
            }
            return Rule.Result.empty();
        }
    }

    private static final class FilterExpressionRewrite
    implements Rule<FilterNode> {
        private final ExpressionRewriter rewriter;

        FilterExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return Patterns.filter();
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            Expression rewritten = this.rewriter.rewrite(filterNode.getPredicate(), context);
            if (filterNode.getPredicate().equals((Object)rewritten)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new FilterNode(filterNode.getId(), filterNode.getSource(), rewritten));
        }
    }

    private static final class AggregationExpressionRewrite
    implements Rule<AggregationNode> {
        private final ExpressionRewriter rewriter;

        AggregationExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<AggregationNode> getPattern() {
            return Patterns.aggregation();
        }

        @Override
        public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableMap.Builder aggregations = ImmutableMap.builder();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregationNode.getAggregations().entrySet()) {
                AggregationNode.Aggregation aggregation = entry.getValue();
                FunctionCall call = (FunctionCall)this.rewriter.rewrite((Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)aggregation.getResolvedFunction().getSignature().getName()), Optional.empty(), aggregation.getFilter().map(symbol -> new SymbolReference(symbol.getName())), aggregation.getOrderingScheme().map(orderBy -> new OrderBy((List)orderBy.getOrderBy().stream().map(symbol -> new SortItem((Expression)new SymbolReference(symbol.getName()), orderBy.getOrdering((Symbol)symbol).isAscending() ? SortItem.Ordering.ASCENDING : SortItem.Ordering.DESCENDING, orderBy.getOrdering((Symbol)symbol).isNullsFirst() ? SortItem.NullOrdering.FIRST : SortItem.NullOrdering.LAST)).collect(ImmutableList.toImmutableList()))), aggregation.isDistinct(), Optional.empty(), aggregation.getArguments()), context);
                Verify.verify((boolean)ResolvedFunction.fromQualifiedName(call.getName()).map(ResolvedFunction::getSignature).map(Signature::getName).map(QualifiedName::of).orElse(call.getName()).equals((Object)QualifiedName.of((String)aggregation.getResolvedFunction().getSignature().getName())), (String)"Aggregation function name changed", (Object[])new Object[0]);
                AggregationNode.Aggregation newAggregation = new AggregationNode.Aggregation(aggregation.getResolvedFunction(), call.getArguments(), call.isDistinct(), call.getFilter().map(Symbol::from), call.getOrderBy().map(OrderingScheme::fromOrderBy), aggregation.getMask());
                aggregations.put((Object)entry.getKey(), (Object)newAggregation);
                if (aggregation.equals(newAggregation)) continue;
                anyRewritten = true;
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new AggregationNode(aggregationNode.getId(), aggregationNode.getSource(), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedSymbols(), aggregationNode.getStep(), aggregationNode.getHashSymbol(), aggregationNode.getGroupIdSymbol()));
            }
            return Rule.Result.empty();
        }
    }

    private static final class ProjectExpressionRewrite
    implements Rule<ProjectNode> {
        private final ExpressionRewriter rewriter;

        ProjectExpressionRewrite(ExpressionRewriter rewriter) {
            this.rewriter = rewriter;
        }

        @Override
        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        @Override
        public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
            Assignments assignments = projectNode.getAssignments().rewrite(x -> this.rewriter.rewrite((Expression)x, context));
            if (projectNode.getAssignments().equals(assignments)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new ProjectNode(projectNode.getId(), projectNode.getSource(), assignments));
        }
    }

    public static interface ExpressionRewriter {
        public Expression rewrite(Expression var1, Rule.Context var2);
    }
}

