/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.CurrentTime;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Extract;
import io.prestosql.sql.tree.Format;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.WhenClause;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class CanonicalizeExpressionRewriter {
    public static Expression canonicalizeExpression(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata, expressionTypes), (Expression)expression);
    }

    private CanonicalizeExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, types, expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata, expressionTypes), (Expression)expression);
    }

    private static boolean isConstant(Expression expression) {
        if (expression instanceof Cast && ((Cast)expression).getExpression() instanceof Literal) {
            return true;
        }
        return expression instanceof Literal;
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Metadata metadata, Map<NodeRef<Expression>, Type> expressionTypes) {
            this.metadata = metadata;
            this.expressionTypes = expressionTypes;
        }

        public Expression rewriteComparisonExpression(ComparisonExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (CanonicalizeExpressionRewriter.isConstant(node.getLeft()) && !CanonicalizeExpressionRewriter.isConstant(node.getRight())) {
                node = new ComparisonExpression(node.getOperator().flip(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        public Expression rewriteArithmeticBinary(ArithmeticBinaryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if ((node.getOperator() == ArithmeticBinaryExpression.Operator.MULTIPLY || node.getOperator() == ArithmeticBinaryExpression.Operator.ADD) && CanonicalizeExpressionRewriter.isConstant(node.getLeft()) && !CanonicalizeExpressionRewriter.isConstant(node.getRight())) {
                node = new ArithmeticBinaryExpression(node.getOperator(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        public Expression rewriteIsNotNullPredicate(IsNotNullPredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            return new NotExpression((Expression)new IsNullPredicate(value));
        }

        public Expression rewriteIfExpression(IfExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression condition = treeRewriter.rewrite(node.getCondition(), (Object)context);
            Expression trueValue = treeRewriter.rewrite(node.getTrueValue(), (Object)context);
            Optional<Expression> falseValue = node.getFalseValue().map(value -> treeRewriter.rewrite(value, (Object)context));
            return new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause(condition, trueValue)), falseValue);
        }

        public Expression rewriteCurrentTime(CurrentTime node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (node.getPrecision() != null) {
                throw new UnsupportedOperationException("not yet implemented: non-default precision");
            }
            switch (node.getFunction()) {
                case DATE: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"current_date")).build();
                }
                case TIME: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"current_time")).build();
                }
                case LOCALTIME: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"localtime")).build();
                }
                case TIMESTAMP: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"current_timestamp")).build();
                }
                case LOCALTIMESTAMP: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"localtimestamp")).build();
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getFunction());
        }

        public Expression rewriteExtract(Extract node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getExpression(), (Object)context);
            Type type = this.expressionTypes.get(NodeRef.of((Node)node.getExpression()));
            switch (node.getField()) {
                case YEAR: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"year")).addArgument(type, value).build();
                }
                case QUARTER: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"quarter")).addArgument(type, value).build();
                }
                case MONTH: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"month")).addArgument(type, value).build();
                }
                case WEEK: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"week")).addArgument(type, value).build();
                }
                case DAY: 
                case DAY_OF_MONTH: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"day")).addArgument(type, value).build();
                }
                case DAY_OF_WEEK: 
                case DOW: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"day_of_week")).addArgument(type, value).build();
                }
                case DAY_OF_YEAR: 
                case DOY: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"day_of_year")).addArgument(type, value).build();
                }
                case YEAR_OF_WEEK: 
                case YOW: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"year_of_week")).addArgument(type, value).build();
                }
                case HOUR: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"hour")).addArgument(type, value).build();
                }
                case MINUTE: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"minute")).addArgument(type, value).build();
                }
                case SECOND: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"second")).addArgument(type, value).build();
                }
                case TIMEZONE_MINUTE: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"timezone_minute")).addArgument(type, value).build();
                }
                case TIMEZONE_HOUR: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"timezone_hour")).addArgument(type, value).build();
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getField());
        }

        public Expression rewriteFormat(Format node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List arguments = (List)node.getArguments().stream().map(value -> treeRewriter.rewrite(value, (Object)context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)node.getArguments().stream().map(NodeRef::of).map(this.expressionTypes::get).collect(ImmutableList.toImmutableList());
            return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$format")).addArgument((Type)VarcharType.VARCHAR, (Expression)arguments.get(0)).addArgument((Type)RowType.anonymous(argumentTypes.subList(1, arguments.size())), (Expression)new Row(arguments.subList(1, arguments.size()))).build();
        }
    }
}

