/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.execution.TableInfo;
import io.prestosql.split.SplitSource;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StageExecutionPlan {
    private final PlanFragment fragment;
    private final Map<PlanNodeId, SplitSource> splitSources;
    private final List<StageExecutionPlan> subStages;
    private final Optional<List<String>> fieldNames;
    private final Map<PlanNodeId, TableInfo> tables;

    public StageExecutionPlan(PlanFragment fragment, Map<PlanNodeId, SplitSource> splitSources, List<StageExecutionPlan> subStages, Map<PlanNodeId, TableInfo> tables) {
        this.fragment = Objects.requireNonNull(fragment, "fragment is null");
        this.splitSources = Objects.requireNonNull(splitSources, "dataSource is null");
        this.subStages = ImmutableList.copyOf((Collection)Objects.requireNonNull(subStages, "dependencies is null"));
        this.fieldNames = fragment.getRoot() instanceof OutputNode ? Optional.of(ImmutableList.copyOf(((OutputNode)fragment.getRoot()).getColumnNames())) : Optional.empty();
        this.tables = ImmutableMap.copyOf(Objects.requireNonNull(tables, "tables is null"));
    }

    public List<String> getFieldNames() {
        Preconditions.checkState((boolean)this.fieldNames.isPresent(), (Object)"cannot get field names from non-output stage");
        return this.fieldNames.get();
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public Map<PlanNodeId, SplitSource> getSplitSources() {
        return this.splitSources;
    }

    public List<StageExecutionPlan> getSubStages() {
        return this.subStages;
    }

    public Map<PlanNodeId, TableInfo> getTables() {
        return this.tables;
    }

    public StageExecutionPlan withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new StageExecutionPlan(this.fragment.withBucketToPartition(bucketToPartition), this.splitSources, this.subStages, this.tables);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fragment", (Object)this.fragment).add("splitSources", this.splitSources).add("subStages", this.subStages).toString();
    }
}

