/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.ArrayConstructor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class DesugarArrayConstructorRewriter {
    public static Expression rewrite(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(expressionTypes, metadata), (Expression)expression);
    }

    private DesugarArrayConstructorRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider typeProvider) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, typeProvider, expression);
        return DesugarArrayConstructorRewriter.rewrite(expression, expressionTypes, metadata);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> expressionTypes;
        private final Metadata metadata;

        public Visitor(Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata) {
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
            this.metadata = metadata;
        }

        public Expression rewriteArrayConstructor(ArrayConstructor node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            ArrayConstructor rewritten = (ArrayConstructor)treeRewriter.defaultRewrite((Expression)node, (Object)context);
            return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"ARRAY_CONSTRUCTOR")).setArguments(this.getTypes(node.getValues()), rewritten.getValues()).build();
        }

        private List<Type> getTypes(List<Expression> expressions) {
            return (List)expressions.stream().map(NodeRef::of).map(this.expressionTypes::get).collect(ImmutableList.toImmutableList());
        }
    }
}

