/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import java.util.Map;
import java.util.Set;

public final class Coercer {
    private Coercer() {
    }

    public static Expression addCoercions(Expression expression, Analysis analysis) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Rewriter(analysis.getCoercions(), analysis.getTypeOnlyCoercions()), (Expression)expression);
    }

    public static Expression addCoercions(Expression expression, Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Rewriter(coercions, typeOnlyCoercions), (Expression)expression);
    }

    private static class Rewriter
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> coercions;
        private final Set<NodeRef<Expression>> typeOnlyCoercions;

        public Rewriter(Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions) {
            this.coercions = coercions;
            this.typeOnlyCoercions = typeOnlyCoercions;
        }

        protected Expression rewriteExpression(Expression expression, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Type target = this.coercions.get(NodeRef.of((Node)expression));
            Expression rewritten = treeRewriter.defaultRewrite(expression, null);
            if (target != null) {
                rewritten = new Cast(rewritten, TypeSignatureTranslator.toSqlType(target), false, this.typeOnlyCoercions.contains(NodeRef.of((Node)expression)));
            }
            return rewritten;
        }
    }
}

