/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.SqlTypeBytecodeExpression;
import io.prestosql.sql.relational.RowExpression;
import java.util.List;

public class RowConstructorCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(ResolvedFunction resolvedFunction, BytecodeGeneratorContext context, Type rowType, List<RowExpression> arguments) {
        BytecodeBlock block = new BytecodeBlock().setDescription("Constructor for " + rowType.toString());
        CallSiteBinder binder = context.getCallSiteBinder();
        Scope scope = context.getScope();
        List types = rowType.getTypeParameters();
        block.comment("Create new RowBlockBuilder; beginBlockEntry;");
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        Variable singleRowBlockWriter = scope.createTempVariable(BlockBuilder.class);
        block.append((BytecodeNode)blockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, rowType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)1)})));
        block.append((BytecodeNode)singleRowBlockWriter.set(blockBuilder.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
        for (int i = 0; i < arguments.size(); ++i) {
            Type fieldType = (Type)types.get(i);
            Variable field = scope.createTempVariable(fieldType.getJavaType());
            block.comment("Clean wasNull and Generate + " + i + "-th field of row");
            block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
            block.append(context.generate(arguments.get(i)));
            block.putVariable(field);
            block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)context.wasNull()).ifTrue((BytecodeNode)singleRowBlockWriter.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, fieldType).writeValue((BytecodeExpression)singleRowBlockWriter, (BytecodeExpression)field).pop()));
        }
        block.comment("closeEntry; slice the SingleRowBlock; wasNull = false;");
        block.append((BytecodeNode)blockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        block.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, rowType).invoke("getObject", Object.class, new BytecodeExpression[]{blockBuilder.cast(Block.class), BytecodeExpressions.constantInt((int)0)}).cast(Block.class));
        block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
        return block;
    }
}

