/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import io.prestosql.sql.relational.SpecialForm;
import io.prestosql.sql.relational.VariableReferenceExpression;
import java.util.List;

public final class LambdaExpressionExtractor {
    private LambdaExpressionExtractor() {
    }

    public static List<LambdaDefinitionExpression> extractLambdaExpressions(RowExpression expression) {
        Visitor visitor = new Visitor();
        expression.accept(visitor, new Context(false));
        return visitor.getLambdaExpressionsPostOrder();
    }

    private static class Context {
        private final boolean inLambda;

        public Context(boolean inLambda) {
            this.inLambda = inLambda;
        }

        public boolean isInLambda() {
            return this.inLambda;
        }
    }

    private static class Visitor
    implements RowExpressionVisitor<Void, Context> {
        private final ImmutableList.Builder<LambdaDefinitionExpression> lambdaExpressions = ImmutableList.builder();

        private Visitor() {
        }

        @Override
        public Void visitInputReference(InputReferenceExpression node, Context context) {
            return null;
        }

        @Override
        public Void visitCall(CallExpression call, Context context) {
            for (RowExpression rowExpression : call.getArguments()) {
                rowExpression.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitSpecialForm(SpecialForm specialForm, Context context) {
            for (RowExpression rowExpression : specialForm.getArguments()) {
                rowExpression.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitConstant(ConstantExpression literal, Context context) {
            return null;
        }

        @Override
        public Void visitLambda(LambdaDefinitionExpression lambda, Context context) {
            lambda.getBody().accept(this, new Context(true));
            this.lambdaExpressions.add((Object)lambda);
            return null;
        }

        @Override
        public Void visitVariableReference(VariableReferenceExpression reference, Context context) {
            return null;
        }

        private List<LambdaDefinitionExpression> getLambdaExpressionsPostOrder() {
            return this.lambdaExpressions.build();
        }
    }
}

