/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.NamedTypeSignature;
import io.prestosql.spi.type.RowFieldName;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.DataType;
import io.prestosql.sql.tree.DataTypeParameter;
import io.prestosql.sql.tree.DateTimeDataType;
import io.prestosql.sql.tree.GenericDataType;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.IntervalDayTimeDataType;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NumericParameter;
import io.prestosql.sql.tree.RowDataType;
import io.prestosql.sql.tree.TypeParameter;
import io.prestosql.type.IntervalDayTimeType;
import io.prestosql.type.IntervalYearMonthType;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.assertj.core.util.VisibleForTesting;

public class TypeSignatureTranslator {
    private TypeSignatureTranslator() {
    }

    public static DataType toSqlType(Type type) {
        return TypeSignatureTranslator.toDataType(type.getTypeSignature());
    }

    public static TypeSignature toTypeSignature(DataType type) {
        if (type instanceof DateTimeDataType) {
            return TypeSignatureTranslator.toTypeSignature((DateTimeDataType)type);
        }
        if (type instanceof IntervalDayTimeDataType) {
            return TypeSignatureTranslator.toTypeSignature((IntervalDayTimeDataType)type);
        }
        if (type instanceof RowDataType) {
            return TypeSignatureTranslator.toTypeSignature((RowDataType)type);
        }
        if (type instanceof GenericDataType) {
            return TypeSignatureTranslator.toTypeSignature((GenericDataType)type);
        }
        throw new UnsupportedOperationException("Unsupported DataType: " + type.getClass().getName());
    }

    private static TypeSignature toTypeSignature(GenericDataType type) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (DataTypeParameter parameter : type.getArguments()) {
            if (parameter instanceof NumericParameter) {
                String value = ((NumericParameter)parameter).getValue();
                try {
                    parameters.add((Object)TypeSignatureParameter.numericParameter((long)Long.parseLong(value)));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)parameter, "Invalid type parameter: %s", value);
                }
            }
            if (parameter instanceof TypeParameter) {
                parameters.add((Object)TypeSignatureParameter.typeParameter((TypeSignature)TypeSignatureTranslator.toTypeSignature(((TypeParameter)parameter).getValue())));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported type parameter kind: " + parameter.getClass().getName());
        }
        return new TypeSignature(TypeSignatureTranslator.canonicalize(type.getName()), (List)parameters.build());
    }

    private static TypeSignature toTypeSignature(RowDataType type) {
        List parameters = (List)type.getFields().stream().map(field -> TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(field.getName().map(TypeSignatureTranslator::canonicalize).map(value -> new RowFieldName(value)), TypeSignatureTranslator.toTypeSignature(field.getType())))).collect(ImmutableList.toImmutableList());
        return new TypeSignature("row", parameters);
    }

    private static TypeSignature toTypeSignature(IntervalDayTimeDataType type) {
        if (type.getFrom() == IntervalDayTimeDataType.Field.YEAR && type.getTo() == IntervalDayTimeDataType.Field.MONTH) {
            return IntervalYearMonthType.INTERVAL_YEAR_MONTH.getTypeSignature();
        }
        if (type.getFrom() == IntervalDayTimeDataType.Field.DAY && type.getTo() == IntervalDayTimeDataType.Field.SECOND) {
            return IntervalDayTimeType.INTERVAL_DAY_TIME.getTypeSignature();
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("INTERVAL %s TO %s type not supported", type.getFrom(), type.getTo()));
    }

    private static TypeSignature toTypeSignature(DateTimeDataType type) {
        boolean withTimeZone = type.isWithTimeZone();
        if (type.getPrecision().isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s type with non-default precision not yet supported", type.getType()));
        }
        switch (type.getType()) {
            case TIMESTAMP: {
                if (withTimeZone) {
                    return TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.getTypeSignature();
                }
                return TimestampType.TIMESTAMP.getTypeSignature();
            }
            case TIME: {
                if (withTimeZone) {
                    return TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.getTypeSignature();
                }
                return TimeType.TIME.getTypeSignature();
            }
        }
        throw new UnsupportedOperationException("Unknown dateTime type: " + type.getType());
    }

    private static String canonicalize(Identifier identifier) {
        if (identifier.isDelimited()) {
            return identifier.getValue();
        }
        return identifier.getValue().toLowerCase(Locale.ENGLISH);
    }

    @VisibleForTesting
    static DataType toDataType(TypeSignature typeSignature) {
        switch (typeSignature.getBase()) {
            case "interval year to month": {
                return new IntervalDayTimeDataType(Optional.empty(), IntervalDayTimeDataType.Field.YEAR, IntervalDayTimeDataType.Field.MONTH);
            }
            case "interval day to second": {
                return new IntervalDayTimeDataType(Optional.empty(), IntervalDayTimeDataType.Field.DAY, IntervalDayTimeDataType.Field.SECOND);
            }
            case "timestamp with time zone": {
                return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIMESTAMP, true, Optional.empty());
            }
            case "timestamp": {
                return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIMESTAMP, false, Optional.empty());
            }
            case "time with time zone": {
                return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIME, true, Optional.empty());
            }
            case "time": {
                return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIME, false, Optional.empty());
            }
            case "row": {
                return new RowDataType(Optional.empty(), (List)typeSignature.getParameters().stream().map(parameter -> new RowDataType.Field(Optional.empty(), parameter.getNamedTypeSignature().getFieldName().map(fieldName -> new Identifier(fieldName.getName(), false)), TypeSignatureTranslator.toDataType(parameter.getNamedTypeSignature().getTypeSignature()))).collect(ImmutableList.toImmutableList()));
            }
            case "varchar": {
                return new GenericDataType(Optional.empty(), new Identifier(typeSignature.getBase(), false), (List)typeSignature.getParameters().stream().filter(parameter -> parameter.getLongLiteral() != Integer.MAX_VALUE).map(parameter -> new NumericParameter(Optional.empty(), String.valueOf(parameter))).collect(ImmutableList.toImmutableList()));
            }
        }
        return new GenericDataType(Optional.empty(), new Identifier(typeSignature.getBase(), false), (List)typeSignature.getParameters().stream().map(parameter -> {
            switch (parameter.getKind()) {
                case LONG: {
                    return new NumericParameter(Optional.empty(), String.valueOf(parameter.getLongLiteral()));
                }
                case TYPE: {
                    return new TypeParameter(TypeSignatureTranslator.toDataType(parameter.getTypeSignature()));
                }
            }
            throw new UnsupportedOperationException("Unsupported parameter kind");
        }).collect(ImmutableList.toImmutableList()));
    }
}

