/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.split;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.Split;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.EmptyPageSource;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.split.PageSourceProvider;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class PageSourceManager
implements PageSourceProvider {
    private final ConcurrentMap<CatalogName, ConnectorPageSourceProvider> pageSourceProviders = new ConcurrentHashMap<CatalogName, ConnectorPageSourceProvider>();

    public void addConnectorPageSourceProvider(CatalogName catalogName, ConnectorPageSourceProvider pageSourceProvider) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        Preconditions.checkState((this.pageSourceProviders.put(catalogName, pageSourceProvider) == null ? 1 : 0) != 0, (String)"PageSourceProvider for connector '%s' is already registered", (Object)catalogName);
    }

    public void removeConnectorPageSourceProvider(CatalogName catalogName) {
        this.pageSourceProviders.remove(catalogName);
    }

    @Override
    public ConnectorPageSource createPageSource(Session session, Split split, TableHandle table, List<ColumnHandle> columns, Supplier<TupleDomain<ColumnHandle>> dynamicFilter) {
        Objects.requireNonNull(columns, "columns is null");
        Preconditions.checkArgument((boolean)split.getCatalogName().equals(table.getCatalogName()), (Object)"mismatched split and table");
        CatalogName catalogName = split.getCatalogName();
        ConnectorPageSourceProvider provider = this.getPageSourceProvider(catalogName);
        TupleDomain<ColumnHandle> constraint = dynamicFilter.get();
        if (constraint.isNone()) {
            return new EmptyPageSource();
        }
        return provider.createPageSource(table.getTransaction(), session.toConnectorSession(catalogName), split.getConnectorSplit(), table.getConnectorHandle(), columns, constraint);
    }

    private ConnectorPageSourceProvider getPageSourceProvider(CatalogName catalogName) {
        ConnectorPageSourceProvider provider = (ConnectorPageSourceProvider)this.pageSourceProviders.get(catalogName);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No page source provider for connector: %s", (Object)catalogName);
        return provider;
    }
}

