/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.prestosql.spi.security.PasswordAuthenticator;
import io.prestosql.spi.security.PasswordAuthenticatorFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class PasswordAuthenticatorManager {
    private static final Logger log = Logger.get(PasswordAuthenticatorManager.class);
    private static final File CONFIG_FILE = new File("etc/password-authenticator.properties");
    private static final String NAME_PROPERTY = "password-authenticator.name";
    private final AtomicBoolean required = new AtomicBoolean();
    private final Map<String, PasswordAuthenticatorFactory> factories = new ConcurrentHashMap<String, PasswordAuthenticatorFactory>();
    private final AtomicReference<PasswordAuthenticator> authenticator = new AtomicReference();

    public void setRequired() {
        this.required.set(true);
    }

    public void addPasswordAuthenticatorFactory(PasswordAuthenticatorFactory factory) {
        Preconditions.checkArgument((this.factories.putIfAbsent(factory.getName(), factory) == null ? 1 : 0) != 0, (String)"Password authenticator '%s' is already registered", (Object)factory.getName());
    }

    public boolean isLoaded() {
        return this.authenticator.get() != null;
    }

    public void loadPasswordAuthenticator() throws Exception {
        if (!this.required.get()) {
            return;
        }
        File configFile = CONFIG_FILE.getAbsoluteFile();
        HashMap properties = new HashMap(ConfigurationLoader.loadPropertiesFrom((String)configFile.getPath()));
        String name = (String)properties.remove(NAME_PROPERTY);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Password authenticator configuration %s does not contain '%s'", (Object)configFile, (Object)NAME_PROPERTY);
        log.info("-- Loading password authenticator --");
        PasswordAuthenticatorFactory factory = this.factories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Password authenticator '%s' is not registered", (Object)name);
        PasswordAuthenticator authenticator = factory.create((Map)ImmutableMap.copyOf(properties));
        this.authenticator.set(Objects.requireNonNull(authenticator, "authenticator is null"));
        log.info("-- Loaded password authenticator %s --", new Object[]{name});
    }

    public PasswordAuthenticator getAuthenticator() {
        Preconditions.checkState((boolean)this.isLoaded(), (Object)"authenticator was not loaded");
        return this.authenticator.get();
    }

    @VisibleForTesting
    public void setAuthenticator(PasswordAuthenticator authenticator) {
        if (!this.authenticator.compareAndSet(null, authenticator)) {
            throw new IllegalStateException("authenticator already loaded");
        }
    }
}

