/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import io.prestosql.server.security.AuthenticationException;
import io.prestosql.server.security.Authenticator;
import io.prestosql.server.security.CertificateConfig;
import io.prestosql.server.security.UserMapping;
import io.prestosql.server.security.UserMappingException;
import io.prestosql.spi.security.Identity;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.inject.Inject;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;

public class CertificateAuthenticator
implements Authenticator {
    private static final String X509_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private final UserMapping userMapping;

    @Inject
    public CertificateAuthenticator(CertificateConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
    }

    @Override
    public Identity authenticate(HttpServletRequest request) throws AuthenticationException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute(X509_ATTRIBUTE);
        if (certs == null || certs.length == 0) {
            throw new AuthenticationException(null);
        }
        X500Principal principal = certs[0].getSubjectX500Principal();
        try {
            String authenticatedUser = this.userMapping.mapUser(principal.toString());
            return Identity.forUser((String)authenticatedUser).withPrincipal((Principal)principal).build();
        }
        catch (UserMappingException e) {
            throw new AuthenticationException(e.getMessage());
        }
    }
}

