/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import io.prestosql.failuredetector.HeartbeatFailureDetector;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;

@Path(value="/v1/node")
public class NodeResource {
    private final HeartbeatFailureDetector failureDetector;

    @Inject
    public NodeResource(HeartbeatFailureDetector failureDetector) {
        this.failureDetector = failureDetector;
    }

    @GET
    public Collection<HeartbeatFailureDetector.Stats> getNodeStats() {
        return this.failureDetector.getStats().values();
    }

    @GET
    @Path(value="failed")
    public Collection<HeartbeatFailureDetector.Stats> getFailed() {
        return Maps.filterKeys(this.failureDetector.getStats(), (Predicate)Predicates.in(this.failureDetector.getFailed())).values();
    }
}

