/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import io.prestosql.Session;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.SystemSecurityContext;
import io.prestosql.transaction.TransactionId;
import java.util.Objects;

public class SecurityContext {
    private final TransactionId transactionId;
    private final Identity identity;

    public static SecurityContext of(Session session) {
        Objects.requireNonNull(session, "session is null");
        return new SecurityContext(session.getRequiredTransactionId(), session.getIdentity());
    }

    public SecurityContext(TransactionId transactionId, Identity identity) {
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public SystemSecurityContext toSystemSecurityContext() {
        return new SystemSecurityContext(this.identity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityContext that = (SecurityContext)o;
        return Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.identity, that.identity);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.identity);
    }
}

