/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.annotations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.ParametricFunctionHelpers;
import io.prestosql.operator.ParametricImplementation;
import io.prestosql.operator.TypeSignatureParser;
import io.prestosql.operator.annotations.FunctionsParserHelper;
import io.prestosql.operator.annotations.ImplementationDependency;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.util.Failures;
import io.prestosql.util.Reflection;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ParametricScalarImplementation
implements ParametricImplementation {
    private final Signature signature;
    private final List<Optional<Class<?>>> argumentNativeContainerTypes;
    private final Map<String, Class<?>> specializedTypeParameters;
    private final Class<?> returnNativeContainerType;
    private final List<ParametricScalarImplementationChoice> choices;
    private final boolean nullable;
    private final List<FunctionArgumentDefinition> argumentDefinitions;

    private ParametricScalarImplementation(Signature signature, List<Optional<Class<?>>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters, List<ParametricScalarImplementationChoice> choices, Class<?> returnContainerType) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.argumentNativeContainerTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes is null"));
        this.specializedTypeParameters = ImmutableMap.copyOf(Objects.requireNonNull(specializedTypeParameters, "specializedTypeParameters is null"));
        this.choices = Objects.requireNonNull(choices, "choices is null");
        Preconditions.checkArgument((!choices.isEmpty() ? 1 : 0) != 0, (Object)"choices is empty");
        this.returnNativeContainerType = Objects.requireNonNull(returnContainerType, "return native container type is null");
        for (Class<?> specializedJavaType : specializedTypeParameters.values()) {
            Preconditions.checkArgument((specializedJavaType != Object.class ? 1 : 0) != 0, (Object)"specializedTypeParameter must not contain Object.class entries");
            Preconditions.checkArgument((!Primitives.isWrapperType(specializedJavaType) ? 1 : 0) != 0, (Object)"specializedTypeParameter must not contain boxed primitive types");
        }
        ParametricScalarImplementationChoice defaultChoice = choices.get(0);
        boolean expression = defaultChoice.getArgumentProperties().stream().noneMatch(argumentProperty -> argumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.VALUE_TYPE && argumentProperty.getNullConvention() == ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION);
        Preconditions.checkArgument((boolean)expression, (String)"default choice cannot use the BLOCK_AND_POSITION calling convention: %s", (Object)signature);
        this.nullable = defaultChoice.isNullable();
        Preconditions.checkArgument((boolean)choices.stream().allMatch(choice -> choice.isNullable() == this.nullable), (String)"all choices must have the same nullable flag: %s", (Object)signature);
        this.argumentDefinitions = (List)defaultChoice.getArgumentProperties().stream().map(argumentProperty -> argumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.VALUE_TYPE && argumentProperty.getNullConvention() != ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL).map(FunctionArgumentDefinition::new).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)choices.stream().allMatch(choice -> ParametricScalarImplementation.matches(this.argumentDefinitions, choice.getArgumentProperties())), (String)"all choices must have the same nullable parameter flags: %s", (Object)signature);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public List<FunctionArgumentDefinition> getArgumentDefinitions() {
        return this.argumentDefinitions;
    }

    public Optional<ScalarFunctionImplementation> specialize(Signature boundSignature, BoundVariables boundVariables, Metadata metadata) {
        ArrayList<ScalarFunctionImplementation.ScalarImplementationChoice> implementationChoices = new ArrayList<ScalarFunctionImplementation.ScalarImplementationChoice>();
        for (Map.Entry<String, Class<?>> entry : this.specializedTypeParameters.entrySet()) {
            if (entry.getValue() == boundVariables.getTypeVariable(entry.getKey()).getJavaType()) continue;
            return Optional.empty();
        }
        if (this.returnNativeContainerType != Object.class && this.returnNativeContainerType != metadata.getType(boundSignature.getReturnType()).getJavaType()) {
            return Optional.empty();
        }
        for (int i = 0; i < boundSignature.getArgumentTypes().size(); ++i) {
            if (boundSignature.getArgumentTypes().get(i).getBase().equals("function")) {
                if (!this.argumentNativeContainerTypes.get(i).isPresent()) continue;
                return Optional.empty();
            }
            if (!this.argumentNativeContainerTypes.get(i).isPresent()) {
                return Optional.empty();
            }
            Class argumentType = metadata.getType(boundSignature.getArgumentTypes().get(i)).getJavaType();
            Class<?> argumentNativeContainerType = this.argumentNativeContainerTypes.get(i).get();
            if (argumentNativeContainerType == Object.class || argumentNativeContainerType == argumentType) continue;
            return Optional.empty();
        }
        for (ParametricScalarImplementationChoice choice : this.choices) {
            MethodHandle boundMethodHandle = ParametricFunctionHelpers.bindDependencies(choice.getMethodHandle(), choice.getDependencies(), boundVariables, metadata);
            Optional<MethodHandle> boundConstructor = choice.getConstructor().map(constructor -> {
                MethodHandle result = ParametricFunctionHelpers.bindDependencies(constructor, choice.getConstructorDependencies(), boundVariables, metadata);
                Failures.checkCondition(result.type().parameterList().isEmpty(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "All parameters of a constructor in a function definition class must be Dependencies. Signature: %s", boundSignature);
                return result;
            });
            implementationChoices.add(new ScalarFunctionImplementation.ScalarImplementationChoice(choice.nullable, choice.argumentProperties, boundMethodHandle.asType(ParametricScalarImplementation.javaMethodType(choice, boundSignature, metadata)), boundConstructor));
        }
        return Optional.of(new ScalarFunctionImplementation(implementationChoices));
    }

    @Override
    public boolean hasSpecializedTypeParameters() {
        return !this.specializedTypeParameters.isEmpty();
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @VisibleForTesting
    public List<ParametricScalarImplementationChoice> getChoices() {
        return this.choices;
    }

    private static MethodType javaMethodType(ParametricScalarImplementationChoice choice, Signature signature, Metadata metadata) {
        ImmutableList.Builder methodHandleParameterTypes = ImmutableList.builder();
        if (choice.getConstructor().isPresent()) {
            methodHandleParameterTypes.add(Object.class);
        }
        if (choice.hasConnectorSession()) {
            methodHandleParameterTypes.add(ConnectorSession.class);
        }
        List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties = choice.getArgumentProperties();
        block10: for (int i = 0; i < argumentProperties.size(); ++i) {
            ScalarFunctionImplementation.ArgumentProperty argumentProperty = argumentProperties.get(i);
            switch (argumentProperty.getArgumentType()) {
                case VALUE_TYPE: {
                    Type signatureType = metadata.getType(signature.getArgumentTypes().get(i));
                    switch (argumentProperty.getNullConvention()) {
                        case RETURN_NULL_ON_NULL: {
                            methodHandleParameterTypes.add((Object)signatureType.getJavaType());
                            continue block10;
                        }
                        case USE_NULL_FLAG: {
                            methodHandleParameterTypes.add((Object)signatureType.getJavaType());
                            methodHandleParameterTypes.add(Boolean.TYPE);
                            continue block10;
                        }
                        case USE_BOXED_TYPE: {
                            methodHandleParameterTypes.add((Object)Primitives.wrap((Class)signatureType.getJavaType()));
                            continue block10;
                        }
                        case BLOCK_AND_POSITION: {
                            methodHandleParameterTypes.add(Block.class);
                            methodHandleParameterTypes.add(Integer.TYPE);
                            continue block10;
                        }
                    }
                    throw new UnsupportedOperationException("unknown NullConvention");
                }
                case FUNCTION_TYPE: {
                    methodHandleParameterTypes.add(argumentProperty.getLambdaInterface());
                    continue block10;
                }
                default: {
                    throw new UnsupportedOperationException("unknown ArgumentType");
                }
            }
        }
        Class methodHandleReturnType = metadata.getType(signature.getReturnType()).getJavaType();
        if (choice.isNullable()) {
            methodHandleReturnType = Primitives.wrap((Class)methodHandleReturnType);
        }
        return MethodType.methodType(methodHandleReturnType, methodHandleParameterTypes.build());
    }

    private static boolean matches(List<FunctionArgumentDefinition> argumentDefinitions, List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties) {
        if (argumentDefinitions.size() != argumentProperties.size()) {
            return false;
        }
        for (int i = 0; i < argumentDefinitions.size(); ++i) {
            boolean actualNullable;
            boolean expectedNullable = argumentDefinitions.get(i).isNullable();
            ScalarFunctionImplementation.ArgumentProperty actualArgumentProperty = argumentProperties.get(i);
            if (actualArgumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.FUNCTION_TYPE) {
                if (!expectedNullable) continue;
                return false;
            }
            ScalarFunctionImplementation.NullConvention actualNullConvention = actualArgumentProperty.getNullConvention();
            if (actualNullConvention == ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION) continue;
            boolean bl = actualNullable = actualNullConvention != ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL;
            if (expectedNullable == actualNullable) continue;
            return false;
        }
        return true;
    }

    public static final class Parser {
        private final String functionName;
        private final boolean nullable;
        private final List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties = new ArrayList<ScalarFunctionImplementation.ArgumentProperty>();
        private final TypeSignature returnType;
        private final List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
        private final List<Optional<Class<?>>> argumentNativeContainerTypes = new ArrayList();
        private final MethodHandle methodHandle;
        private final List<ImplementationDependency> dependencies = new ArrayList<ImplementationDependency>();
        private final Set<TypeParameter> typeParameters = new LinkedHashSet<TypeParameter>();
        private final Set<String> literalParameters;
        private final ImmutableSet<String> typeParameterNames;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Optional<MethodHandle> constructorMethodHandle;
        private final List<ImplementationDependency> constructorDependencies = new ArrayList<ImplementationDependency>();
        private final List<LongVariableConstraint> longVariableConstraints;
        private final Class<?> returnNativeContainerType;
        private boolean hasConnectorSession;
        private final ParametricScalarImplementationChoice choice;

        Parser(String functionName, Method method, Optional<Constructor<?>> constructor) {
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            this.nullable = method.getAnnotation(SqlNullable.class) != null;
            Preconditions.checkArgument((this.nullable || !FunctionsParserHelper.containsLegacyNullable(method.getAnnotations()) ? 1 : 0) != 0, (String)"Method [%s] is annotated with @Nullable but not @SqlNullable", (Object)method);
            this.typeParameters.addAll(Arrays.asList(method.getAnnotationsByType(TypeParameter.class)));
            this.literalParameters = FunctionsParserHelper.parseLiteralParameters(method);
            this.typeParameterNames = (ImmutableSet)this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableSet.toImmutableSet());
            SqlType returnType = method.getAnnotation(SqlType.class);
            Preconditions.checkArgument((returnType != null ? 1 : 0) != 0, (String)"Method [%s] is missing @SqlType annotation", (Object)method);
            this.returnType = TypeSignatureParser.parseTypeSignature(returnType.value(), this.literalParameters);
            Class<?> actualReturnType = method.getReturnType();
            this.returnNativeContainerType = Primitives.unwrap(actualReturnType);
            if (Primitives.isWrapperType(actualReturnType)) {
                Preconditions.checkArgument((boolean)this.nullable, (String)"Method [%s] has wrapper return type %s but is missing @SqlNullable", (Object)method, (Object)actualReturnType.getSimpleName());
            } else if (actualReturnType.isPrimitive()) {
                Preconditions.checkArgument((!this.nullable ? 1 : 0) != 0, (String)"Method [%s] annotated with @SqlNullable has primitive return type %s", (Object)method, (Object)actualReturnType.getSimpleName());
            }
            this.longVariableConstraints = FunctionsParserHelper.parseLongVariableConstraints(method);
            this.specializedTypeParameters = FunctionsParserHelper.getDeclaredSpecializedTypeParameters(method, this.typeParameters);
            for (TypeParameter typeParameter : this.typeParameters) {
                Preconditions.checkArgument((boolean)typeParameter.value().matches("[A-Z][A-Z0-9]*"), (String)"Expected type parameter to only contain A-Z and 0-9 (starting with A-Z), but got %s on method [%s]", (Object)typeParameter.value(), (Object)method);
            }
            this.inferSpecialization(method, actualReturnType, returnType.value());
            this.parseArguments(method);
            this.constructorMethodHandle = this.getConstructor(method, constructor);
            this.methodHandle = this.getMethodHandle(method);
            this.choice = new ParametricScalarImplementationChoice(this.nullable, this.hasConnectorSession, this.argumentProperties, this.methodHandle, this.constructorMethodHandle, this.dependencies, this.constructorDependencies);
        }

        private void parseArguments(Method method) {
            boolean encounteredNonDependencyAnnotation = false;
            int i = 0;
            while (i < method.getParameterCount()) {
                ScalarFunctionImplementation.NullConvention nullConvention;
                Parameter parameter = method.getParameters()[i];
                Class<?> parameterType = parameter.getType();
                if (parameterType == ConnectorSession.class) {
                    Failures.checkCondition(!this.hasConnectorSession, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] has more than 1 ConnectorSession in the parameter list", method);
                    this.hasConnectorSession = true;
                    ++i;
                    continue;
                }
                Optional<Annotation> implementationDependency = ImplementationDependency.getImplementationDependencyAnnotation(parameter);
                if (implementationDependency.isPresent()) {
                    Failures.checkCondition(!encounteredNonDependencyAnnotation, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] has parameters annotated with Dependency annotations that appears after other parameters", method);
                    ImplementationDependency.validateImplementationDependencyAnnotation(method, implementationDependency.get(), this.typeParameterNames, this.literalParameters);
                    this.dependencies.add(ImplementationDependency.Factory.createDependency(implementationDependency.get(), this.literalParameters));
                    ++i;
                    continue;
                }
                encounteredNonDependencyAnnotation = true;
                Annotation[] annotations = parameter.getAnnotations();
                Preconditions.checkArgument((boolean)Stream.of(annotations).noneMatch(IsNull.class::isInstance), (String)"Method [%s] has @IsNull parameter that does not follow a @SqlType parameter", (Object)method);
                SqlType type = Stream.of(annotations).filter(SqlType.class::isInstance).map(SqlType.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Method [%s] is missing @SqlType annotation for parameter", method)));
                TypeSignature typeSignature = TypeSignatureParser.parseTypeSignature(type.value(), this.literalParameters);
                this.argumentTypes.add(typeSignature);
                if (typeSignature.getBase().equals("function")) {
                    Failures.checkCondition(parameterType.isAnnotationPresent(FunctionalInterface.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "argument %s is marked as lambda but the function interface class is not annotated: %s", i, this.methodHandle);
                    this.argumentProperties.add(ScalarFunctionImplementation.ArgumentProperty.functionTypeArgumentProperty(parameterType));
                    this.argumentNativeContainerTypes.add(Optional.empty());
                    ++i;
                    continue;
                }
                if (Stream.of(annotations).anyMatch(SqlNullable.class::isInstance)) {
                    Failures.checkCondition(!parameterType.isPrimitive(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] has parameter with primitive type %s annotated with @SqlNullable", method, parameterType.getSimpleName());
                    nullConvention = ScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE;
                } else if (Stream.of(annotations).anyMatch(BlockPosition.class::isInstance)) {
                    Preconditions.checkState((method.getParameterCount() > i + 1 ? 1 : 0) != 0);
                    Preconditions.checkState((parameterType == Block.class ? 1 : 0) != 0);
                    nullConvention = ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION;
                    Annotation[] parameterAnnotations = method.getParameterAnnotations()[i + 1];
                    Preconditions.checkState((boolean)Stream.of(parameterAnnotations).anyMatch(BlockIndex.class::isInstance));
                } else {
                    Failures.checkCondition(parameterType == Void.class || !Primitives.isWrapperType(parameterType), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "A parameter with USE_NULL_FLAG or RETURN_NULL_ON_NULL convention must not use wrapper type. Found in method [%s]", method);
                    boolean useNullFlag = false;
                    if (method.getParameterCount() > i + 1) {
                        Annotation[] parameterAnnotations = method.getParameterAnnotations()[i + 1];
                        if (Stream.of(parameterAnnotations).anyMatch(IsNull.class::isInstance)) {
                            Class<?> isNullType = method.getParameterTypes()[i + 1];
                            Preconditions.checkArgument((boolean)Stream.of(parameterAnnotations).filter(FunctionsParserHelper::isPrestoAnnotation).allMatch(IsNull.class::isInstance), (String)"Method [%s] has @IsNull parameter that has other annotations", (Object)method);
                            Preconditions.checkArgument((isNullType == Boolean.TYPE ? 1 : 0) != 0, (String)"Method [%s] has non-boolean parameter with @IsNull", (Object)method);
                            Preconditions.checkArgument((parameterType == Void.class || !Primitives.isWrapperType(parameterType) ? 1 : 0) != 0, (String)"Method [%s] uses @IsNull following a parameter with boxed primitive type: %s", (Object)method, (Object)parameterType.getSimpleName());
                            useNullFlag = true;
                        }
                    }
                    nullConvention = useNullFlag ? ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG : ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL;
                }
                if (nullConvention == ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION) {
                    this.argumentNativeContainerTypes.add(Optional.of(type.nativeContainerType()));
                } else {
                    this.inferSpecialization(method, parameterType, type.value());
                    Failures.checkCondition(type.nativeContainerType().equals(Object.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "@SqlType can only contain an explicitly specified nativeContainerType when using @BlockPosition", new Object[0]);
                    this.argumentNativeContainerTypes.add(Optional.of(Primitives.unwrap(parameterType)));
                }
                this.argumentProperties.add(ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(nullConvention));
                i += nullConvention.getParameterCount();
            }
        }

        private void inferSpecialization(Method method, Class<?> parameterType, String typeParameterName) {
            if (this.typeParameterNames.contains((Object)typeParameterName) && parameterType != Object.class) {
                Class<?> specialization = this.specializedTypeParameters.get(typeParameterName);
                Class nativeParameterType = Primitives.unwrap(parameterType);
                Preconditions.checkArgument((specialization == null || specialization.equals(nativeParameterType) ? 1 : 0) != 0, (String)"Method [%s] type %s has conflicting specializations %s and %s", (Object)method, (Object)typeParameterName, specialization, (Object)nativeParameterType);
                this.specializedTypeParameters.put(typeParameterName, nativeParameterType);
            }
        }

        private Optional<MethodHandle> getConstructor(Method method, Optional<Constructor<?>> optionalConstructor) {
            if (Modifier.isStatic(method.getModifiers())) {
                return Optional.empty();
            }
            Preconditions.checkArgument((boolean)optionalConstructor.isPresent(), (String)"Method [%s] is an instance method. It must be in a class annotated with @ScalarFunction or @ScalarOperator, and the class is required to have a public constructor.", (Object)method);
            Constructor<?> constructor = optionalConstructor.get();
            Set constructorTypeParameters = (Set)Stream.of(constructor.getAnnotationsByType(TypeParameter.class)).collect(ImmutableSet.toImmutableSet());
            Preconditions.checkArgument((boolean)constructorTypeParameters.containsAll(this.typeParameters), (String)"Method [%s] is an instance method and requires a public constructor containing all type parameters: %s", (Object)method, this.typeParameters);
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                Annotation[] annotations = constructor.getParameterAnnotations()[i];
                Preconditions.checkArgument((boolean)FunctionsParserHelper.containsImplementationDependencyAnnotation(annotations), (String)"Constructors may only have meta parameters [%s]", constructor);
                Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (String)"Meta parameters may only have a single annotation [%s]", constructor);
                Annotation annotation = annotations[0];
                if (annotation instanceof TypeParameter) {
                    ImplementationDependency.checkTypeParameters(TypeSignatureParser.parseTypeSignature(((TypeParameter)annotation).value(), (Set<String>)ImmutableSet.of()), this.typeParameterNames, method);
                }
                this.constructorDependencies.add(ImplementationDependency.Factory.createDependency(annotation, this.literalParameters));
            }
            MethodHandle result = Reflection.constructorMethodHandle(StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, constructor);
            return Optional.of(result.asType(result.type().changeReturnType(Object.class)));
        }

        private MethodHandle getMethodHandle(Method method) {
            MethodHandle methodHandle = Reflection.methodHandle(StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, method);
            if (!Modifier.isStatic(method.getModifiers())) {
                int i;
                methodHandle = methodHandle.asType(methodHandle.type().changeParameterType(0, Object.class));
                int[] permutedIndices = new int[methodHandle.type().parameterCount()];
                permutedIndices[0] = this.dependencies.size();
                MethodType newType = methodHandle.type().changeParameterType(this.dependencies.size(), (Class<?>)methodHandle.type().parameterType(0));
                for (i = 0; i < this.dependencies.size(); ++i) {
                    permutedIndices[i + 1] = i;
                    newType = newType.changeParameterType(i, (Class<?>)methodHandle.type().parameterType(i + 1));
                }
                for (i = this.dependencies.size() + 1; i < permutedIndices.length; ++i) {
                    permutedIndices[i] = i;
                }
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, permutedIndices);
            }
            return methodHandle;
        }

        public List<Optional<Class<?>>> getArgumentNativeContainerTypes() {
            return this.argumentNativeContainerTypes;
        }

        public Map<String, Class<?>> getSpecializedTypeParameters() {
            return this.specializedTypeParameters;
        }

        public Class<?> getReturnNativeContainerType() {
            return this.returnNativeContainerType;
        }

        public ParametricScalarImplementationChoice getChoice() {
            return this.choice;
        }

        public SpecializedSignature getSpecializedSignature() {
            return new SpecializedSignature(this.getSignature(), this.argumentNativeContainerTypes, this.specializedTypeParameters, this.returnNativeContainerType);
        }

        public Signature getSignature() {
            return new Signature(this.functionName, FunctionsParserHelper.createTypeVariableConstraints(this.typeParameters, this.dependencies), this.longVariableConstraints, this.returnType, this.argumentTypes, false);
        }
    }

    public static final class SpecializedSignature {
        private final Signature signature;
        private final List<Optional<Class<?>>> argumentNativeContainerTypes;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Class<?> returnNativeContainerType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecializedSignature that = (SpecializedSignature)o;
            return Objects.equals(this.signature, that.signature) && Objects.equals(this.argumentNativeContainerTypes, that.argumentNativeContainerTypes) && Objects.equals(this.specializedTypeParameters, that.specializedTypeParameters) && Objects.equals(this.returnNativeContainerType, that.returnNativeContainerType);
        }

        public int hashCode() {
            return Objects.hash(this.signature, this.argumentNativeContainerTypes, this.specializedTypeParameters, this.returnNativeContainerType);
        }

        private SpecializedSignature(Signature signature, List<Optional<Class<?>>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters, Class<?> returnNativeContainerType) {
            this.signature = signature;
            this.argumentNativeContainerTypes = argumentNativeContainerTypes;
            this.specializedTypeParameters = specializedTypeParameters;
            this.returnNativeContainerType = returnNativeContainerType;
        }
    }

    public static final class ParametricScalarImplementationChoice
    implements Comparable<ParametricScalarImplementationChoice> {
        private final boolean nullable;
        private final List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties;
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> constructor;
        private final List<ImplementationDependency> dependencies;
        private final List<ImplementationDependency> constructorDependencies;
        private final int numberOfBlockPositionArguments;
        private final boolean hasConnectorSession;

        private ParametricScalarImplementationChoice(boolean nullable, boolean hasConnectorSession, List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties, MethodHandle methodHandle, Optional<MethodHandle> constructor, List<ImplementationDependency> dependencies, List<ImplementationDependency> constructorDependencies) {
            this.nullable = nullable;
            this.hasConnectorSession = hasConnectorSession;
            this.argumentProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentProperties, "argumentProperties is null"));
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.constructor = Objects.requireNonNull(constructor, "constructor is null");
            this.dependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(dependencies, "dependencies is null"));
            this.constructorDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(constructorDependencies, "constructorDependencies is null"));
            int numberOfBlockPositionArguments = 0;
            for (ScalarFunctionImplementation.ArgumentProperty argumentProperty : argumentProperties) {
                if (argumentProperty.getArgumentType() != ScalarFunctionImplementation.ArgumentType.VALUE_TYPE || argumentProperty.getNullConvention() != ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION) continue;
                ++numberOfBlockPositionArguments;
            }
            this.numberOfBlockPositionArguments = numberOfBlockPositionArguments;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean hasConnectorSession() {
            return this.hasConnectorSession;
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        @VisibleForTesting
        public List<ImplementationDependency> getDependencies() {
            return this.dependencies;
        }

        public List<ScalarFunctionImplementation.ArgumentProperty> getArgumentProperties() {
            return this.argumentProperties;
        }

        public boolean checkDependencies() {
            for (int i = 1; i < this.getDependencies().size(); ++i) {
                if (this.getDependencies().get(i).equals(this.getDependencies().get(0))) continue;
                return false;
            }
            return true;
        }

        @VisibleForTesting
        public List<ImplementationDependency> getConstructorDependencies() {
            return this.constructorDependencies;
        }

        public Optional<MethodHandle> getConstructor() {
            return this.constructor;
        }

        @Override
        public int compareTo(ParametricScalarImplementationChoice choice) {
            if (choice.numberOfBlockPositionArguments < this.numberOfBlockPositionArguments) {
                return 1;
            }
            return -1;
        }
    }

    public static final class Builder {
        private final Signature signature;
        private final List<Optional<Class<?>>> argumentNativeContainerTypes;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Class<?> returnNativeContainerType;
        private final List<ParametricScalarImplementationChoice> choices;

        public Builder(Signature signature, List<Optional<Class<?>>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters, Class<?> returnNativeContainerType) {
            this.signature = Objects.requireNonNull(signature, "signature is null");
            this.argumentNativeContainerTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes is null"));
            this.specializedTypeParameters = ImmutableMap.copyOf(Objects.requireNonNull(specializedTypeParameters, "specializedTypeParameters is null"));
            this.choices = new ArrayList<ParametricScalarImplementationChoice>();
            this.returnNativeContainerType = Objects.requireNonNull(returnNativeContainerType, "return native container type is null");
        }

        void addChoice(ParametricScalarImplementationChoice choice) {
            this.choices.add(choice);
        }

        public ParametricScalarImplementation build() {
            this.choices.sort(ParametricScalarImplementationChoice::compareTo);
            return new ParametricScalarImplementation(this.signature, this.argumentNativeContainerTypes, this.specializedTypeParameters, this.choices, this.returnNativeContainerType);
        }
    }
}

