/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.stats.QuantileDigest;
import io.prestosql.operator.aggregation.FloatingPointBitsConverterUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.util.Failures;

public final class QuantileDigestFunctions {
    public static final double DEFAULT_ACCURACY = 0.01;
    public static final long DEFAULT_WEIGHT = 1L;

    private QuantileDigestFunctions() {
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="double")
    public static double valueAtQuantileDouble(@SqlType(value="qdigest(double)") Slice input, @SqlType(value="double") double quantile) {
        return FloatingPointBitsConverterUtil.sortableLongToDouble(QuantileDigestFunctions.valueAtQuantileBigint(input, quantile));
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="real")
    public static long valueAtQuantileReal(@SqlType(value="qdigest(real)") Slice input, @SqlType(value="double") double quantile) {
        return Float.floatToRawIntBits(FloatingPointBitsConverterUtil.sortableIntToFloat((int)QuantileDigestFunctions.valueAtQuantileBigint(input, quantile)));
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="bigint")
    public static long valueAtQuantileBigint(@SqlType(value="qdigest(bigint)") Slice input, @SqlType(value="double") double quantile) {
        return new QuantileDigest(input).getQuantile(quantile);
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="array(double)")
    public static Block valuesAtQuantilesDouble(@SqlType(value="qdigest(double)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        QuantileDigest digest = new QuantileDigest(input);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            DoubleType.DOUBLE.writeDouble(output, FloatingPointBitsConverterUtil.sortableLongToDouble(digest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i))));
        }
        return output.build();
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="array(real)")
    public static Block valuesAtQuantilesReal(@SqlType(value="qdigest(real)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        QuantileDigest digest = new QuantileDigest(input);
        BlockBuilder output = RealType.REAL.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            RealType.REAL.writeLong(output, (long)Float.floatToRawIntBits(FloatingPointBitsConverterUtil.sortableIntToFloat((int)digest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)))));
        }
        return output.build();
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="array(bigint)")
    public static Block valuesAtQuantilesBigint(@SqlType(value="qdigest(bigint)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        QuantileDigest digest = new QuantileDigest(input);
        BlockBuilder output = BigintType.BIGINT.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            BigintType.BIGINT.writeLong(output, digest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)));
        }
        return output.build();
    }

    public static double verifyAccuracy(double accuracy) {
        Failures.checkCondition(accuracy > 0.0 && accuracy < 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile accuracy must be exclusively between 0 and 1, was %s", accuracy);
        return accuracy;
    }

    public static long verifyWeight(long weight) {
        Failures.checkCondition(weight > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile weight must be > 0, was %s", weight);
        return weight;
    }
}

