/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameters;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.INDETERMINATE)
public final class MapIndeterminateOperator {
    private MapIndeterminateOperator() {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="boolean")
    public static boolean indeterminate(@OperatorDependency(operator=OperatorType.INDETERMINATE, argumentTypes={"V"}) MethodHandle valueIndeterminateFunction, @TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType, @SqlType(value="map(K,V)") Block block, @IsNull boolean isNull) {
        if (isNull) {
            return true;
        }
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            if (block.isNull(i + 1)) {
                return true;
            }
            try {
                if (!valueIndeterminateFunction.invoke(TypeUtils.readNativeValue((Type)valueType, (Block)block, (int)(i + 1)), false)) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return false;
    }
}

