/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameters;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import java.util.List;

@ScalarFunction(value="map_entries")
@Description(value="Construct an array of entries from a given map")
public class MapEntriesFunction {
    private final PageBuilder pageBuilder;

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public MapEntriesFunction(@TypeParameter(value="array(row(K,V))") Type arrayType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)arrayType));
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="array(row(K,V))")
    public Block mapFromEntries(@TypeParameter(value="row(K,V)") RowType rowType, @SqlType(value="map(K,V)") Block block) {
        Verify.verify((rowType.getTypeParameters().size() == 2 ? 1 : 0) != 0);
        Verify.verify((block.getPositionCount() % 2 == 0 ? 1 : 0) != 0);
        Type keyType = (Type)rowType.getTypeParameters().get(0);
        Type valueType = (Type)rowType.getTypeParameters().get(1);
        ArrayType arrayType = new ArrayType((Type)rowType);
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        int entryCount = block.getPositionCount() / 2;
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        for (int i = 0; i < entryCount; ++i) {
            BlockBuilder rowBuilder = entryBuilder.beginBlockEntry();
            keyType.appendTo(block, 2 * i, rowBuilder);
            valueType.appendTo(block, 2 * i + 1, rowBuilder);
            entryBuilder.closeEntry();
        }
        blockBuilder.closeEntry();
        this.pageBuilder.declarePosition();
        return arrayType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }
}

