/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.operator.annotations.ScalarImplementationDependency;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.TypeSignature;
import java.util.Objects;
import java.util.Optional;

public final class CastImplementationDependency
extends ScalarImplementationDependency {
    private final TypeSignature fromType;
    private final TypeSignature toType;

    public CastImplementationDependency(TypeSignature fromType, TypeSignature toType, Optional<InvocationConvention> invocationConvention) {
        super(invocationConvention);
        this.fromType = Objects.requireNonNull(fromType, "fromType is null");
        this.toType = Objects.requireNonNull(toType, "toType is null");
    }

    public TypeSignature getFromType() {
        return this.fromType;
    }

    public TypeSignature getToType() {
        return this.toType;
    }

    @Override
    protected ResolvedFunction getResolvedFunction(BoundVariables boundVariables, Metadata metadata) {
        return metadata.getCoercion(metadata.getType(SignatureBinder.applyBoundVariables(this.fromType, boundVariables)), metadata.getType(SignatureBinder.applyBoundVariables(this.toType, boundVariables)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CastImplementationDependency that = (CastImplementationDependency)o;
        return Objects.equals(this.fromType, that.fromType) && Objects.equals(this.toType, that.toType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fromType, this.toType);
    }
}

