/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import io.prestosql.operator.aggregation.state.NullableBooleanState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;

public class NullableBooleanStateSerializer
implements AccumulatorStateSerializer<NullableBooleanState> {
    public Type getSerializedType() {
        return BooleanType.BOOLEAN;
    }

    public void serialize(NullableBooleanState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BooleanType.BOOLEAN.writeBoolean(out, state.getBoolean());
        }
    }

    public void deserialize(Block block, int index, NullableBooleanState state) {
        state.setNull(false);
        state.setBoolean(BooleanType.BOOLEAN.getBoolean(block, index));
    }
}

