/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.aggregation.AccumulatorCompiler;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.state.NullableBooleanState;
import io.prestosql.operator.aggregation.state.NullableDoubleState;
import io.prestosql.operator.aggregation.state.NullableLongState;
import io.prestosql.operator.aggregation.state.StateCompiler;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.sql.gen.lambda.BinaryFunctionInterface;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class ReduceAggregationFunction
extends SqlAggregationFunction {
    public static final ReduceAggregationFunction REDUCE_AGG = new ReduceAggregationFunction();
    private static final String NAME = "reduce_agg";
    private static final MethodHandle LONG_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", NullableLongState.class, Object.class, Long.TYPE, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle DOUBLE_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", NullableDoubleState.class, Object.class, Double.TYPE, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle BOOLEAN_STATE_INPUT_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "input", NullableBooleanState.class, Object.class, Boolean.TYPE, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle LONG_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", NullableLongState.class, NullableLongState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle DOUBLE_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", NullableDoubleState.class, NullableDoubleState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle BOOLEAN_STATE_COMBINE_FUNCTION = Reflection.methodHandle(ReduceAggregationFunction.class, "combine", NullableBooleanState.class, NullableBooleanState.class, BinaryFunctionInterface.class, BinaryFunctionInterface.class);
    private static final MethodHandle LONG_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableLongState.class, "write", Type.class, NullableLongState.class, BlockBuilder.class);
    private static final MethodHandle DOUBLE_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableDoubleState.class, "write", Type.class, NullableDoubleState.class, BlockBuilder.class);
    private static final MethodHandle BOOLEAN_STATE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableBooleanState.class, "write", Type.class, NullableBooleanState.class, BlockBuilder.class);

    public ReduceAggregationFunction() {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T"), (Object)Signature.typeVariable("S")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("S", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0]), (Object)new TypeSignature("S", new TypeSignatureParameter[0]), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("S", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), new TypeSignature("S", new TypeSignatureParameter[0])}), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("S", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("S", new TypeSignatureParameter[0]), new TypeSignature("S", new TypeSignatureParameter[0])})), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, true, "Reduce input elements into a single value", FunctionKind.AGGREGATE), true, false);
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        Type inputType = boundVariables.getTypeVariable("T");
        Type stateType = boundVariables.getTypeVariable("S");
        return this.generateAggregation(inputType, stateType);
    }

    private InternalAggregationFunction generateAggregation(Type inputType, Type stateType) {
        AggregationMetadata.AccumulatorStateDescriptor stateDescriptor;
        MethodHandle outputMethodHandle;
        MethodHandle combineMethodHandle;
        MethodHandle inputMethodHandle;
        DynamicClassLoader classLoader = new DynamicClassLoader(ReduceAggregationFunction.class.getClassLoader());
        if (stateType.getJavaType() == Long.TYPE) {
            inputMethodHandle = LONG_STATE_INPUT_FUNCTION;
            combineMethodHandle = LONG_STATE_COMBINE_FUNCTION;
            outputMethodHandle = LONG_STATE_OUTPUT_FUNCTION.bindTo(stateType);
            stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(NullableLongState.class, StateCompiler.generateStateSerializer(NullableLongState.class, classLoader), StateCompiler.generateStateFactory(NullableLongState.class, classLoader));
        } else if (stateType.getJavaType() == Double.TYPE) {
            inputMethodHandle = DOUBLE_STATE_INPUT_FUNCTION;
            combineMethodHandle = DOUBLE_STATE_COMBINE_FUNCTION;
            outputMethodHandle = DOUBLE_STATE_OUTPUT_FUNCTION.bindTo(stateType);
            stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(NullableDoubleState.class, StateCompiler.generateStateSerializer(NullableDoubleState.class, classLoader), StateCompiler.generateStateFactory(NullableDoubleState.class, classLoader));
        } else if (stateType.getJavaType() == Boolean.TYPE) {
            inputMethodHandle = BOOLEAN_STATE_INPUT_FUNCTION;
            combineMethodHandle = BOOLEAN_STATE_COMBINE_FUNCTION;
            outputMethodHandle = BOOLEAN_STATE_OUTPUT_FUNCTION.bindTo(stateType);
            stateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor(NullableBooleanState.class, StateCompiler.generateStateSerializer(NullableBooleanState.class, classLoader), StateCompiler.generateStateFactory(NullableBooleanState.class, classLoader));
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("State type not supported for %s: %s", NAME, stateType.getDisplayName()));
        }
        String name = this.getFunctionMetadata().getSignature().getName();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(name, inputType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)inputType.getTypeSignature())), ReduceAggregationFunction.createInputParameterMetadata(inputType, stateType), inputMethodHandle.asType(inputMethodHandle.type().changeParameterType(1, inputType.getJavaType())), Optional.empty(), combineMethodHandle, outputMethodHandle, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)stateDescriptor), inputType, (List<Class<?>>)ImmutableList.of(BinaryFunctionInterface.class, BinaryFunctionInterface.class));
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(name, (List<Type>)ImmutableList.of((Object)inputType), (List<Type>)ImmutableList.of((Object)stateType), stateType, true, false, factory, (List<Class<?>>)ImmutableList.of(BinaryFunctionInterface.class, BinaryFunctionInterface.class));
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type inputType, Type stateType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, inputType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, stateType));
    }

    public static void input(NullableLongState state, Object value, long initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(initialStateValue);
        }
        state.setLong((Long)inputFunction.apply(state.getLong(), value));
    }

    public static void input(NullableDoubleState state, Object value, double initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(initialStateValue);
        }
        state.setDouble((Double)inputFunction.apply(state.getDouble(), value));
    }

    public static void input(NullableBooleanState state, Object value, boolean initialStateValue, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setBoolean(initialStateValue);
        }
        state.setBoolean((Boolean)inputFunction.apply(state.getBoolean(), value));
    }

    public static void combine(NullableLongState state, NullableLongState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(otherState.getLong());
            return;
        }
        state.setLong((Long)combineFunction.apply(state.getLong(), otherState.getLong()));
    }

    public static void combine(NullableDoubleState state, NullableDoubleState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(otherState.getDouble());
            return;
        }
        state.setDouble((Double)combineFunction.apply(state.getDouble(), otherState.getDouble()));
    }

    public static void combine(NullableBooleanState state, NullableBooleanState otherState, BinaryFunctionInterface inputFunction, BinaryFunctionInterface combineFunction) {
        if (state.isNull()) {
            state.setNull(false);
            state.setBoolean(otherState.getBoolean());
            return;
        }
        state.setBoolean((Boolean)combineFunction.apply(state.getBoolean(), otherState.getBoolean()));
    }
}

