/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.stats.QuantileDigest;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.aggregation.AccumulatorCompiler;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.MapAggregationFunction;
import io.prestosql.operator.aggregation.state.QuantileDigestState;
import io.prestosql.operator.aggregation.state.QuantileDigestStateFactory;
import io.prestosql.operator.aggregation.state.QuantileDigestStateSerializer;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.type.QuantileDigestType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.util.MoreMath;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

@AggregationFunction(value="merge")
public final class MergeQuantileDigestFunction
extends SqlAggregationFunction {
    public static final MergeQuantileDigestFunction MERGE = new MergeQuantileDigestFunction();
    public static final String NAME = "merge";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MergeQuantileDigestFunction.class, "input", Type.class, QuantileDigestState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MergeQuantileDigestFunction.class, "combine", QuantileDigestState.class, QuantileDigestState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MergeQuantileDigestFunction.class, "output", QuantileDigestStateSerializer.class, QuantileDigestState.class, BlockBuilder.class);
    private static final double COMPARISON_EPSILON = 1.0E-6;

    public MergeQuantileDigestFunction() {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parametricType((String)"qdigest", (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])}), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parametricType((String)"qdigest", (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])})), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, "Merges the input quantile digests into a single quantile digest", FunctionKind.AGGREGATE), true, true);
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        Type valueType = boundVariables.getTypeVariable("T");
        QuantileDigestType outputType = (QuantileDigestType)metadata.getParameterizedType("qdigest", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType.getTypeSignature())));
        return MergeQuantileDigestFunction.generateAggregation(valueType, outputType);
    }

    private static InternalAggregationFunction generateAggregation(Type valueType, QuantileDigestType type) {
        DynamicClassLoader classLoader = new DynamicClassLoader(MapAggregationFunction.class.getClassLoader());
        QuantileDigestStateSerializer stateSerializer = new QuantileDigestStateSerializer(valueType);
        Type intermediateType = stateSerializer.getSerializedType();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, type.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)type.getTypeSignature())), MergeQuantileDigestFunction.createInputParameterMetadata((Type)type), INPUT_FUNCTION.bindTo(type), Optional.empty(), COMBINE_FUNCTION, OUTPUT_FUNCTION.bindTo(stateSerializer), (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(QuantileDigestState.class, stateSerializer, new QuantileDigestStateFactory())), (Type)type);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)ImmutableList.of((Object)type), (List<Type>)ImmutableList.of((Object)intermediateType), (Type)type, true, true, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type valueType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, valueType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    @InputFunction
    public static void input(Type type, QuantileDigestState state, Block value, int index) {
        MergeQuantileDigestFunction.merge(state, new QuantileDigest(type.getSlice(value, index)));
    }

    @CombineFunction
    public static void combine(QuantileDigestState state, QuantileDigestState otherState) {
        MergeQuantileDigestFunction.merge(state, otherState.getQuantileDigest());
    }

    private static void merge(QuantileDigestState state, QuantileDigest input) {
        if (input == null) {
            return;
        }
        QuantileDigest previous = state.getQuantileDigest();
        if (previous == null) {
            state.setQuantileDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            Preconditions.checkArgument((boolean)MoreMath.nearlyEqual(previous.getMaxError(), input.getMaxError(), 1.0E-6), (String)"Cannot merge qdigests with different accuracies (%s vs. %s)", (Object)state.getQuantileDigest().getMaxError(), (Object)input.getMaxError());
            Preconditions.checkArgument((boolean)MoreMath.nearlyEqual(previous.getAlpha(), input.getAlpha(), 1.0E-6), (String)"Cannot merge qdigests with different alpha values (%s vs. %s)", (Object)state.getQuantileDigest().getAlpha(), (Object)input.getAlpha());
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    public static void output(QuantileDigestStateSerializer serializer, QuantileDigestState state, BlockBuilder out) {
        serializer.serialize(state, out);
    }
}

