/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import io.prestosql.operator.Work;
import java.util.Objects;
import java.util.function.Function;

public final class TransformWork<I, O>
implements Work<O> {
    private final Work<I> work;
    private final Function<I, O> transformation;
    private boolean finished;
    private O result;

    public TransformWork(Work<I> work, Function<I, O> transformation) {
        this.work = Objects.requireNonNull(work, "work is null");
        this.transformation = Objects.requireNonNull(transformation, "transformation is null");
    }

    @Override
    public boolean process() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0);
        this.finished = this.work.process();
        if (!this.finished) {
            return false;
        }
        this.result = this.transformation.apply(this.work.getResult());
        return true;
    }

    @Override
    public O getResult() {
        Preconditions.checkState((boolean)this.finished, (Object)"process has not finished");
        return this.result;
    }
}

