/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import io.prestosql.Session;
import io.prestosql.execution.Lifespan;
import io.prestosql.execution.TaskId;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.SpillContext;
import java.util.Objects;

public class ProcessorContext {
    private final Session session;
    private final MemoryTrackingContext memoryTrackingContext;
    private final DriverYieldSignal driverYieldSignal;
    private final Lifespan lifespan;
    private final SpillContext spillContext;
    private final TaskId taskId;

    public ProcessorContext(Session session, MemoryTrackingContext memoryTrackingContext, OperatorContext operatorContext) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.memoryTrackingContext = Objects.requireNonNull(memoryTrackingContext, "memoryTrackingContext is null");
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.driverYieldSignal = operatorContext.getDriverContext().getYieldSignal();
        this.lifespan = operatorContext.getDriverContext().getLifespan();
        this.spillContext = operatorContext.getSpillContext();
        this.taskId = operatorContext.getDriverContext().getTaskId();
    }

    public Session getSession() {
        return this.session;
    }

    public MemoryTrackingContext getMemoryTrackingContext() {
        return this.memoryTrackingContext;
    }

    public DriverYieldSignal getDriverYieldSignal() {
        return this.driverYieldSignal;
    }

    public Lifespan getLifespan() {
        return this.lifespan;
    }

    public SpillContext getSpillContext() {
        return this.spillContext;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }
}

