/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import io.prestosql.operator.JoinFilterFunction;
import io.prestosql.operator.LookupSource;
import io.prestosql.operator.PagesHash;
import io.prestosql.operator.PositionLinks;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public final class JoinHash
implements LookupSource {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(JoinHash.class).instanceSize();
    private final PagesHash pagesHash;
    @Nullable
    private final JoinFilterFunction filterFunction;
    @Nullable
    private final PositionLinks positionLinks;

    public JoinHash(PagesHash pagesHash, Optional<JoinFilterFunction> filterFunction, Optional<PositionLinks> positionLinks) {
        this.pagesHash = Objects.requireNonNull(pagesHash, "pagesHash is null");
        this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction cannot be null").orElse(null);
        this.positionLinks = Objects.requireNonNull(positionLinks, "positionLinks is null").orElse(null);
    }

    @Override
    public boolean isEmpty() {
        return this.getJoinPositionCount() == 0L;
    }

    @Override
    public final int getChannelCount() {
        return this.pagesHash.getChannelCount();
    }

    @Override
    public long getJoinPositionCount() {
        return this.pagesHash.getPositionCount();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return (long)INSTANCE_SIZE + this.pagesHash.getInMemorySizeInBytes() + (this.positionLinks == null ? 0L : this.positionLinks.getSizeInBytes());
    }

    @Override
    public long joinPositionWithinPartition(long joinPosition) {
        return joinPosition;
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        int addressIndex = this.pagesHash.getAddressIndex(position, hashChannelsPage);
        return this.startJoinPosition(addressIndex, position, allChannelsPage);
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        int addressIndex = this.pagesHash.getAddressIndex(position, hashChannelsPage, rawHash);
        return this.startJoinPosition(addressIndex, position, allChannelsPage);
    }

    private long startJoinPosition(int currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        if (currentJoinPosition == -1) {
            return -1L;
        }
        if (this.positionLinks == null) {
            return currentJoinPosition;
        }
        return this.positionLinks.start(currentJoinPosition, probePosition, allProbeChannelsPage);
    }

    @Override
    public final long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        if (this.positionLinks == null) {
            return -1L;
        }
        return this.positionLinks.next(Math.toIntExact(currentJoinPosition), probePosition, allProbeChannelsPage);
    }

    @Override
    public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        return this.filterFunction == null || this.filterFunction.filter(Math.toIntExact(currentJoinPosition), probePosition, allProbeChannelsPage);
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.pagesHash.appendTo(Math.toIntExact(position), pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
    }
}

