/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.operator.scalar.annotations.ScalarFromAnnotationsParser;
import io.prestosql.operator.window.WindowAnnotationsParser;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.WindowFunction;
import java.util.Collection;
import java.util.List;

public final class FunctionExtractor {
    private FunctionExtractor() {
    }

    public static List<? extends SqlFunction> extractFunctions(Collection<Class<?>> classes) {
        return (List)classes.stream().map(FunctionExtractor::extractFunctions).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public static List<? extends SqlFunction> extractFunctions(Class<?> clazz) {
        if (WindowFunction.class.isAssignableFrom(clazz)) {
            Class<?> windowClazz = clazz;
            return WindowAnnotationsParser.parseFunctionDefinition(windowClazz);
        }
        if (clazz.isAnnotationPresent(AggregationFunction.class)) {
            return SqlAggregationFunction.createFunctionsByAnnotations(clazz);
        }
        if (clazz.isAnnotationPresent(ScalarFunction.class) || clazz.isAnnotationPresent(ScalarOperator.class)) {
            return ScalarFromAnnotationsParser.parseFunctionDefinition(clazz);
        }
        return ScalarFromAnnotationsParser.parseFunctionDefinitions(clazz);
    }
}

