/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.MoreObjects;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.spi.connector.Connector;
import java.util.Objects;

public class Catalog {
    private final String catalogName;
    private final CatalogName connectorCatalogName;
    private final Connector connector;
    private final CatalogName informationSchemaId;
    private final Connector informationSchema;
    private final CatalogName systemTablesId;
    private final Connector systemTables;

    public Catalog(String catalogName, CatalogName connectorCatalogName, Connector connector, CatalogName informationSchemaId, Connector informationSchema, CatalogName systemTablesId, Connector systemTables) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.connectorCatalogName = Objects.requireNonNull(connectorCatalogName, "connectorConnectorId is null");
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.informationSchemaId = Objects.requireNonNull(informationSchemaId, "informationSchemaId is null");
        this.informationSchema = Objects.requireNonNull(informationSchema, "informationSchema is null");
        this.systemTablesId = Objects.requireNonNull(systemTablesId, "systemTablesId is null");
        this.systemTables = Objects.requireNonNull(systemTables, "systemTables is null");
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public CatalogName getConnectorCatalogName() {
        return this.connectorCatalogName;
    }

    public CatalogName getInformationSchemaId() {
        return this.informationSchemaId;
    }

    public CatalogName getSystemTablesId() {
        return this.systemTablesId;
    }

    public Connector getConnector(CatalogName catalogName) {
        if (this.connectorCatalogName.equals(catalogName)) {
            return this.connector;
        }
        if (this.informationSchemaId.equals(catalogName)) {
            return this.informationSchema;
        }
        if (this.systemTablesId.equals(catalogName)) {
            return this.systemTables;
        }
        throw new IllegalArgumentException("Unknown connector id: " + catalogName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("connectorConnectorId", (Object)this.connectorCatalogName).toString();
    }
}

