/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.buffer;

import com.google.common.base.Preconditions;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.execution.buffer.PageCodecMarker;
import io.prestosql.execution.buffer.PagesSerdeUtil;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spiller.SpillCipher;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PagesSerde {
    private static final double MINIMUM_COMPRESSION_RATIO = 0.8;
    private final BlockEncodingSerde blockEncodingSerde;
    private final Optional<Compressor> compressor;
    private final Optional<Decompressor> decompressor;
    private final Optional<SpillCipher> spillCipher;

    public PagesSerde(BlockEncodingSerde blockEncodingSerde, Optional<Compressor> compressor, Optional<Decompressor> decompressor, Optional<SpillCipher> spillCipher) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        Preconditions.checkArgument((compressor.isPresent() == decompressor.isPresent() ? 1 : 0) != 0, (Object)"compressor and decompressor must both be present or both be absent");
        this.compressor = Objects.requireNonNull(compressor, "compressor is null");
        this.decompressor = Objects.requireNonNull(decompressor, "decompressor is null");
        this.spillCipher = Objects.requireNonNull(spillCipher, "spillCipher is null");
    }

    public SerializedPage serialize(Page page) {
        DynamicSliceOutput serializationBuffer = new DynamicSliceOutput(Math.toIntExact(page.getSizeInBytes() + 4L));
        PagesSerdeUtil.writeRawPage(page, (SliceOutput)serializationBuffer, this.blockEncodingSerde);
        Slice slice = serializationBuffer.slice();
        int uncompressedSize = serializationBuffer.size();
        PageCodecMarker.MarkerSet markers = PageCodecMarker.MarkerSet.empty();
        if (this.compressor.isPresent()) {
            byte[] compressed = new byte[this.compressor.get().maxCompressedLength(uncompressedSize)];
            int compressedSize = this.compressor.get().compress(slice.byteArray(), slice.byteArrayOffset(), uncompressedSize, compressed, 0, compressed.length);
            if ((double)compressedSize / (double)uncompressedSize <= 0.8) {
                slice = Slices.wrappedBuffer((byte[])compressed, (int)0, (int)compressedSize);
                markers.add(PageCodecMarker.COMPRESSED);
            }
        }
        if (this.spillCipher.isPresent()) {
            byte[] encrypted = new byte[this.spillCipher.get().encryptedMaxLength(slice.length())];
            int encryptedSize = this.spillCipher.get().encrypt(slice.byteArray(), slice.byteArrayOffset(), slice.length(), encrypted, 0);
            slice = Slices.wrappedBuffer((byte[])encrypted, (int)0, (int)encryptedSize);
            markers.add(PageCodecMarker.ENCRYPTED);
        }
        if (!slice.isCompact()) {
            slice = Slices.copyOf((Slice)slice);
        }
        return new SerializedPage(slice, markers, page.getPositionCount(), uncompressedSize);
    }

    public Page deserialize(SerializedPage serializedPage) {
        Preconditions.checkArgument((serializedPage != null ? 1 : 0) != 0, (Object)"serializedPage is null");
        Slice slice = serializedPage.getSlice();
        if (serializedPage.isEncrypted()) {
            Preconditions.checkState((boolean)this.spillCipher.isPresent(), (Object)"Page is encrypted, but spill cipher is missing");
            byte[] decrypted = new byte[this.spillCipher.get().decryptedMaxLength(slice.length())];
            int decryptedSize = this.spillCipher.get().decrypt(slice.byteArray(), slice.byteArrayOffset(), slice.length(), decrypted, 0);
            slice = Slices.wrappedBuffer((byte[])decrypted, (int)0, (int)decryptedSize);
        }
        if (serializedPage.isCompressed()) {
            Preconditions.checkState((boolean)this.decompressor.isPresent(), (Object)"Page is compressed, but decompressor is missing");
            int uncompressedSize = serializedPage.getUncompressedSizeInBytes();
            byte[] decompressed = new byte[uncompressedSize];
            Preconditions.checkState((this.decompressor.get().decompress(slice.byteArray(), slice.byteArrayOffset(), slice.length(), decompressed, 0, uncompressedSize) == uncompressedSize ? 1 : 0) != 0);
            slice = Slices.wrappedBuffer((byte[])decompressed);
        }
        return PagesSerdeUtil.readRawPage(serializedPage.getPositionCount(), (SliceInput)slice.getInput(), this.blockEncodingSerde);
    }
}

