/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StageState;
import io.prestosql.execution.StageStats;
import io.prestosql.execution.TableInfo;
import io.prestosql.execution.TaskInfo;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StageInfo {
    private final StageId stageId;
    private final StageState state;
    private final PlanFragment plan;
    private final List<Type> types;
    private final StageStats stageStats;
    private final List<TaskInfo> tasks;
    private final List<StageInfo> subStages;
    private final ExecutionFailureInfo failureCause;
    private final Map<PlanNodeId, TableInfo> tables;

    @JsonCreator
    public StageInfo(@JsonProperty(value="stageId") StageId stageId, @JsonProperty(value="state") StageState state, @JsonProperty(value="plan") @Nullable PlanFragment plan, @JsonProperty(value="types") List<Type> types, @JsonProperty(value="stageStats") StageStats stageStats, @JsonProperty(value="tasks") List<TaskInfo> tasks, @JsonProperty(value="subStages") List<StageInfo> subStages, @JsonProperty(value="tables") Map<PlanNodeId, TableInfo> tables, @JsonProperty(value="failureCause") ExecutionFailureInfo failureCause) {
        Objects.requireNonNull(stageId, "stageId is null");
        Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(stageStats, "stageStats is null");
        Objects.requireNonNull(tasks, "tasks is null");
        Objects.requireNonNull(subStages, "subStages is null");
        Objects.requireNonNull(tables, "tables is null");
        this.stageId = stageId;
        this.state = state;
        this.plan = plan;
        this.types = types;
        this.stageStats = stageStats;
        this.tasks = ImmutableList.copyOf(tasks);
        this.subStages = subStages;
        this.failureCause = failureCause;
        this.tables = ImmutableMap.copyOf(tables);
    }

    @JsonProperty
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public StageState getState() {
        return this.state;
    }

    @JsonProperty
    @Nullable
    public PlanFragment getPlan() {
        return this.plan;
    }

    @JsonProperty
    public List<Type> getTypes() {
        return this.types;
    }

    @JsonProperty
    public StageStats getStageStats() {
        return this.stageStats;
    }

    @JsonProperty
    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    @JsonProperty
    public List<StageInfo> getSubStages() {
        return this.subStages;
    }

    @JsonProperty
    public Map<PlanNodeId, TableInfo> getTables() {
        return this.tables;
    }

    @JsonProperty
    public ExecutionFailureInfo getFailureCause() {
        return this.failureCause;
    }

    public boolean isFinalStageInfo() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.getTaskStatus().getState().isDone());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("state", (Object)this.state).toString();
    }

    public static List<StageInfo> getAllStages(Optional<StageInfo> stageInfo) {
        ImmutableList.Builder collector = ImmutableList.builder();
        StageInfo.addAllStages(stageInfo, (ImmutableList.Builder<StageInfo>)collector);
        return collector.build();
    }

    private static void addAllStages(Optional<StageInfo> stageInfo, ImmutableList.Builder<StageInfo> collector) {
        stageInfo.ifPresent(stage -> {
            collector.add(stage);
            stage.getSubStages().stream().forEach(subStage -> StageInfo.addAllStages(Optional.ofNullable(subStage), collector));
        });
    }

    public boolean isCompleteInfo() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.getTaskStatus().getState().isDone());
    }
}

