/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SplitConcurrencyController {
    private static final double TARGET_UTILIZATION = 0.5;
    private final long adjustmentIntervalNanos;
    private int targetConcurrency;
    private long threadNanosSinceLastAdjustment;

    public SplitConcurrencyController(int initialConcurrency, Duration adjustmentInterval) {
        Preconditions.checkArgument((initialConcurrency > 0 ? 1 : 0) != 0, (Object)"initial concurrency must be positive");
        this.targetConcurrency = initialConcurrency;
        this.adjustmentIntervalNanos = adjustmentInterval.roundTo(TimeUnit.NANOSECONDS);
    }

    public void update(long nanos, double utilization, int currentConcurrency) {
        Preconditions.checkArgument((nanos >= 0L ? 1 : 0) != 0, (Object)"nanos is negative");
        Preconditions.checkArgument((boolean)Double.isFinite(utilization), (Object)"utilization must be finite");
        Preconditions.checkArgument((utilization >= 0.0 ? 1 : 0) != 0, (Object)"utilization is negative");
        Preconditions.checkArgument((currentConcurrency >= 0 ? 1 : 0) != 0, (Object)"currentConcurrency is negative");
        this.threadNanosSinceLastAdjustment += nanos;
        if (this.threadNanosSinceLastAdjustment >= this.adjustmentIntervalNanos && utilization < 0.5 && currentConcurrency >= this.targetConcurrency) {
            this.threadNanosSinceLastAdjustment = 0L;
            ++this.targetConcurrency;
        }
    }

    public int getTargetConcurrency() {
        Preconditions.checkState((this.targetConcurrency > 0 ? 1 : 0) != 0, (Object)"Possible deadlock detected. Target concurrency is zero");
        return this.targetConcurrency;
    }

    public void splitFinished(long splitThreadNanos, double utilization, int currentConcurrency) {
        Preconditions.checkArgument((splitThreadNanos >= 0L ? 1 : 0) != 0, (Object)"nanos is negative");
        Preconditions.checkArgument((boolean)Double.isFinite(utilization), (Object)"utilization must be finite");
        Preconditions.checkArgument((utilization >= 0.0 ? 1 : 0) != 0, (Object)"utilization is negative");
        Preconditions.checkArgument((currentConcurrency >= 0 ? 1 : 0) != 0, (Object)"currentConcurrency is negative");
        if (this.threadNanosSinceLastAdjustment >= this.adjustmentIntervalNanos || this.threadNanosSinceLastAdjustment >= splitThreadNanos) {
            if (utilization > 0.5 && this.targetConcurrency > 1) {
                this.threadNanosSinceLastAdjustment = 0L;
                --this.targetConcurrency;
            } else if (utilization < 0.5 && currentConcurrency >= this.targetConcurrency) {
                this.threadNanosSinceLastAdjustment = 0L;
                ++this.targetConcurrency;
            }
        }
    }
}

