/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.SqlFormatterUtil;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.Deallocate;
import io.prestosql.sql.tree.Execute;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Prepare;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.inject.Inject;

public class PrepareTask
implements DataDefinitionTask<Prepare> {
    private final SqlParser sqlParser;

    @Inject
    public PrepareTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "PREPARE";
    }

    @Override
    public String explain(Prepare statement, List<Expression> parameters) {
        return "PREPARE " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(Prepare prepare, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Statement statement = prepare.getStatement();
        if (statement instanceof Prepare || statement instanceof Execute || statement instanceof Deallocate) {
            String type = statement.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid statement type for prepared statement: " + type);
        }
        String sql = SqlFormatterUtil.getFormattedSql(statement, this.sqlParser);
        stateMachine.addPreparedStatement(prepare.getName().getValue(), sql);
        return Futures.immediateFuture(null);
    }
}

