/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.sql.SqlFormatter;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import java.util.List;

public interface DataDefinitionTask<T extends Statement> {
    public String getName();

    public ListenableFuture<?> execute(T var1, TransactionManager var2, Metadata var3, AccessControl var4, QueryStateMachine var5, List<Expression> var6);

    default public String explain(T statement, List<Expression> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append(SqlFormatter.formatSql(statement));
        if (!parameters.isEmpty()) {
            builder.append("\n").append("Parameters: ").append(parameters);
        }
        return builder.toString();
    }
}

