/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.Session;
import io.prestosql.cost.ComposableStatsCalculator;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.StatsProvider;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public abstract class SimpleStatsRule<T extends PlanNode>
implements ComposableStatsCalculator.Rule<T> {
    private final StatsNormalizer normalizer;

    protected SimpleStatsRule(StatsNormalizer normalizer) {
        this.normalizer = Objects.requireNonNull(normalizer, "normalizer is null");
    }

    @Override
    public final Optional<PlanNodeStatsEstimate> calculate(T node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        return this.doCalculate(node, sourceStats, lookup, session, types).map(estimate -> this.normalizer.normalize((PlanNodeStatsEstimate)estimate, (Collection<Symbol>)node.getOutputSymbols(), types));
    }

    protected abstract Optional<PlanNodeStatsEstimate> doCalculate(T var1, StatsProvider var2, Lookup var3, Session var4, TypeProvider var5);
}

