/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system.jdbc;

import io.prestosql.FullConnectorSession;
import io.prestosql.Session;
import io.prestosql.connector.system.jdbc.FilterUtil;
import io.prestosql.connector.system.jdbc.JdbcTable;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataListing;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class TableJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "tables");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.createUnboundedVarcharType()).column("table_schem", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_type", (Type)VarcharType.createUnboundedVarcharType()).column("remarks", (Type)VarcharType.createUnboundedVarcharType()).column("type_cat", (Type)VarcharType.createUnboundedVarcharType()).column("type_schem", (Type)VarcharType.createUnboundedVarcharType()).column("type_name", (Type)VarcharType.createUnboundedVarcharType()).column("self_referencing_col_name", (Type)VarcharType.createUnboundedVarcharType()).column("ref_generation", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public TableJdbcTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Optional<String> catalogFilter = FilterUtil.stringFilter(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.stringFilter(constraint, 1);
        Optional<String> tableFilter = FilterUtil.stringFilter(constraint, 2);
        Optional<String> typeFilter = FilterUtil.stringFilter(constraint, 3);
        boolean includeTables = FilterUtil.emptyOrEquals(typeFilter, "TABLE");
        boolean includeViews = FilterUtil.emptyOrEquals(typeFilter, "VIEW");
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        if (!includeTables && !includeViews) {
            return table.build().cursor();
        }
        for (String catalog : FilterUtil.filter(MetadataListing.listCatalogs(session, this.metadata, this.accessControl).keySet(), catalogFilter)) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            Set<SchemaTableName> views = MetadataListing.listViews(session, this.metadata, this.accessControl, prefix);
            for (SchemaTableName name : MetadataListing.listTables(session, this.metadata, this.accessControl, prefix)) {
                boolean isView = views.contains(name);
                if ((!includeTables || isView) && (!includeViews || !isView)) continue;
                table.addRow(TableJdbcTable.tableRow(catalog, name, isView ? "VIEW" : "TABLE"));
            }
        }
        return table.build().cursor();
    }

    private static Object[] tableRow(String catalog, SchemaTableName name, String type) {
        return new Object[]{catalog, name.getSchemaName(), name.getTableName(), type, null, null, null, null, null, null};
    }
}

