/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;

public class SystemSplit
implements ConnectorSplit {
    private final List<HostAddress> addresses;
    private final TupleDomain<ColumnHandle> constraint;

    public SystemSplit(HostAddress address, TupleDomain<ColumnHandle> constraint) {
        this((List<HostAddress>)ImmutableList.of((Object)Objects.requireNonNull(address, "address is null")), constraint);
    }

    @JsonCreator
    public SystemSplit(@JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        Objects.requireNonNull(addresses, "hosts is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"hosts is empty");
        this.addresses = ImmutableList.copyOf(addresses);
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addresses", this.addresses).toString();
    }
}

