/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.system.GlobalSystemTransactionHandle;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;

abstract class AbstractPropertiesSystemTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final TransactionManager transactionManager;
    private final Supplier<Map<CatalogName, Map<String, PropertyMetadata<?>>>> propertySupplier;

    protected AbstractPropertiesSystemTable(String tableName, TransactionManager transactionManager, Supplier<Map<CatalogName, Map<String, PropertyMetadata<?>>>> propertySupplier) {
        this.tableMetadata = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(new SchemaTableName("metadata", tableName)).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("property_name", (Type)VarcharType.createUnboundedVarcharType()).column("default_value", (Type)VarcharType.createUnboundedVarcharType()).column("type", (Type)VarcharType.createUnboundedVarcharType()).column("description", (Type)VarcharType.createUnboundedVarcharType()).build();
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.propertySupplier = Objects.requireNonNull(propertySupplier, "propertySupplier is null");
    }

    public final SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public final ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public final RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        TransactionId transactionId = ((GlobalSystemTransactionHandle)transactionHandle).getTransactionId();
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)this.tableMetadata);
        Map<CatalogName, Map<String, PropertyMetadata<?>>> connectorProperties = this.propertySupplier.get();
        for (Map.Entry<String, CatalogName> entry : new TreeMap<String, CatalogName>(this.transactionManager.getCatalogNames(transactionId)).entrySet()) {
            String catalog = entry.getKey();
            TreeMap properties = new TreeMap((Map)connectorProperties.getOrDefault(entry.getValue(), (Map<String, PropertyMetadata<?>>)ImmutableMap.of()));
            for (PropertyMetadata propertyMetadata : properties.values()) {
                table.addRow(new Object[]{catalog, propertyMetadata.getName(), MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString(), propertyMetadata.getSqlType().toString(), propertyMetadata.getDescription()});
            }
        }
        return table.build().cursor();
    }
}

