/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client.testing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.discovery.client.HttpServiceSelector;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class StaticHttpServiceSelector
implements HttpServiceSelector {
    private static final String UNKNOWN_TYPE = "unknown";
    private final String type;
    private final String pool;
    private final List<URI> uris;

    public StaticHttpServiceSelector(URI uri, URI ... uris) {
        this(UNKNOWN_TYPE, "general", uri, uris);
    }

    public StaticHttpServiceSelector(String type, URI uri, URI ... uris) {
        this(type, "general", uri, uris);
    }

    public StaticHttpServiceSelector(String type, String pool, URI uri, URI ... uris) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(pool, "pool is null");
        Objects.requireNonNull(uri, "uri is null");
        Objects.requireNonNull(uris, "uris is null");
        this.type = type;
        this.pool = pool;
        this.uris = ImmutableList.builder().add((Object)uri).add((Object[])uris).build();
    }

    public StaticHttpServiceSelector(Iterable<URI> uris) {
        this(UNKNOWN_TYPE, "general", uris);
    }

    public StaticHttpServiceSelector(String type, Iterable<URI> uris) {
        this(type, "general", uris);
    }

    public StaticHttpServiceSelector(String type, String pool, Iterable<URI> uris) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(pool, "pool is null");
        Objects.requireNonNull(uris, "uris is null");
        this.type = type;
        this.pool = pool;
        this.uris = ImmutableList.copyOf(uris);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<URI> selectHttpService() {
        return this.uris;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("pool", (Object)this.pool).add("uris", this.uris).toString();
    }
}

