/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.weakref.jmx.MBeanAttribute;

class NestedMBeanAttribute
implements MBeanAttribute {
    private final MBeanAttribute delegate;
    private final MBeanAttributeInfo info;

    public NestedMBeanAttribute(String prefix, MBeanAttribute delegate) {
        this.delegate = delegate;
        MBeanAttributeInfo delegateInfo = delegate.getInfo();
        this.info = new MBeanAttributeInfo(prefix + "." + delegateInfo.getName(), delegateInfo.getType(), delegateInfo.getDescription(), delegateInfo.isReadable(), delegateInfo.isWritable(), delegateInfo.isIs(), delegateInfo.getDescriptor());
    }

    @Override
    public MBeanAttributeInfo getInfo() {
        return this.info;
    }

    @Override
    public String getName() {
        return this.info.getName();
    }

    @Override
    public Object getValue() throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.delegate.getValue();
    }

    @Override
    public void setValue(Object value) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.delegate.setValue(value);
    }
}

