/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.DecoderErrorCode;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.decoder.json.AbstractDateTimeJsonValueProvider;
import io.prestosql.decoder.json.JsonFieldDecoder;
import io.prestosql.decoder.json.JsonRowDecoderFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CustomDateTimeJsonFieldDecoder
implements JsonFieldDecoder {
    private static final Set<Type> SUPPORTED_TYPES = ImmutableSet.of((Object)DateType.DATE, (Object)TimeType.TIME, (Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, (Object)TimestampType.TIMESTAMP, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
    private final DecoderColumnHandle columnHandle;
    private final DateTimeFormatter formatter;

    public CustomDateTimeJsonFieldDecoder(DecoderColumnHandle columnHandle) {
        this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
        if (!SUPPORTED_TYPES.contains(columnHandle.getType())) {
            JsonRowDecoderFactory.throwUnsupportedColumnType(columnHandle);
        }
        Preconditions.checkArgument((columnHandle.getFormatHint() != null ? 1 : 0) != 0, (String)"format hint not defined for column '%s'", (Object)columnHandle.getName());
        try {
            this.formatter = DateTimeFormat.forPattern((String)columnHandle.getFormatHint()).withLocale(Locale.ENGLISH).withZoneUTC();
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("invalid joda pattern '%s' passed as format hint for column '%s'", columnHandle.getFormatHint(), columnHandle.getName()));
        }
    }

    @Override
    public FieldValueProvider decode(JsonNode value) {
        return new CustomDateTimeJsonValueProvider(value, this.columnHandle, this.formatter);
    }

    public static class CustomDateTimeJsonValueProvider
    extends AbstractDateTimeJsonValueProvider {
        private final DateTimeFormatter formatter;

        public CustomDateTimeJsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle, DateTimeFormatter formatter) {
            super(value, columnHandle);
            this.formatter = formatter;
        }

        @Override
        protected long getMillis() {
            if (!this.value.isValueNode()) {
                throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", this.columnHandle.getType(), this.columnHandle.getName()));
            }
            try {
                return this.formatter.parseMillis(this.value.asText());
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
            }
        }
    }
}

