/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import java.util.Objects;

public class ConfigurationAwareModules {
    private ConfigurationAwareModules() {
    }

    public static Module combine(final Module ... modules) {
        Preconditions.checkArgument((modules.length > 0 ? 1 : 0) != 0, (Object)"No modules given");
        if (modules.length == 1) {
            return modules[0];
        }
        return new AbstractConfigurationAwareModule(){

            @Override
            protected void setup(Binder binder) {
                for (Module module : modules) {
                    Objects.requireNonNull(module, "module is null");
                    this.install(module);
                }
            }
        };
    }
}

