/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.client.IntervalDayTime;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.AbstractLongType;
import io.prestosql.type.IntervalDayTimeType;

public final class IntervalDayTimeOperators {
    private IntervalDayTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="interval day to second")
    public static long add(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByBigint(@SqlType(value="interval day to second") long left, @SqlType(value="bigint") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        if (Double.isNaN(right)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot multiply by double NaN");
        }
        return (long)((double)left * right);
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long bigintMultiply(@SqlType(value="bigint") long left, @SqlType(value="interval day to second") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long doubleMultiply(@SqlType(value="double") double left, @SqlType(value="interval day to second") long right) {
        if (Double.isNaN(left)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot multiply by double NaN");
        }
        return (long)(left * (double)right);
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="interval day to second")
    public static long divideByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        if (Double.isNaN(right) || right == 0.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Cannot divide by double %s", right));
        }
        return (long)((double)left / right);
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="interval day to second")
    public static long negate(@SqlType(value="interval day to second") long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="interval day to second") long value, @SqlType(value="interval day to second") long min, @SqlType(value="interval day to second") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(@SqlType(value="interval day to second") long value) {
        return Slices.utf8Slice((String)IntervalDayTime.formatMillis((long)value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="interval day to second") long value) {
        return AbstractLongType.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="interval day to second") long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="interval day to second") long value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static final class IntervalDayTimeDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="interval day to second") long left, @IsNull boolean leftNull, @SqlType(value="interval day to second") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return IntervalDayTimeOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="interval day to second", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="interval day to second", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return IntervalDayTimeOperators.notEqual(IntervalDayTimeType.INTERVAL_DAY_TIME.getLong(left, leftPosition), IntervalDayTimeType.INTERVAL_DAY_TIME.getLong(right, rightPosition));
        }
    }
}

