/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.prestosql.eventlistener.EventListenerConfig;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.spi.eventlistener.EventListener;
import io.prestosql.spi.eventlistener.EventListenerFactory;
import io.prestosql.spi.eventlistener.QueryCompletedEvent;
import io.prestosql.spi.eventlistener.QueryCreatedEvent;
import io.prestosql.spi.eventlistener.SplitCompletedEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TestingEventListenerManager
extends EventListenerManager {
    private final Set<EventListener> configuredEventListeners = Collections.synchronizedSet(new HashSet());

    @Inject
    public TestingEventListenerManager(EventListenerConfig config) {
        super(config);
    }

    @Override
    public void addEventListenerFactory(EventListenerFactory eventListenerFactory) {
        this.configuredEventListeners.add(eventListenerFactory.create((Map)ImmutableMap.of()));
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        this.configuredEventListeners.add(eventListener);
    }

    @Override
    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        for (EventListener listener : this.configuredEventListeners) {
            listener.queryCompleted(queryCompletedEvent);
        }
    }

    @Override
    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        for (EventListener listener : this.configuredEventListeners) {
            listener.queryCreated(queryCreatedEvent);
        }
    }

    @Override
    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        for (EventListener listener : this.configuredEventListeners) {
            listener.splitCompleted(splitCompletedEvent);
        }
    }
}

