/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.DistinctLimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RemoveRedundantDistinctLimit
implements Rule<DistinctLimitNode> {
    private static final Pattern<DistinctLimitNode> PATTERN = Patterns.distinctLimit();

    @Override
    public Pattern<DistinctLimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(DistinctLimitNode node, Captures captures, Rule.Context context) {
        Preconditions.checkArgument((!node.getHashSymbol().isPresent() ? 1 : 0) != 0, (Object)"HashSymbol should be empty");
        if (node.getLimit() == 0L) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of()));
        }
        if (QueryCardinalityUtil.isScalar(node.getSource(), context.getLookup())) {
            return Rule.Result.ofPlanNode(node.getSource());
        }
        if (QueryCardinalityUtil.isAtMost(node.getSource(), context.getLookup(), node.getLimit())) {
            return Rule.Result.ofPlanNode(new AggregationNode(node.getId(), node.getSource(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(node.getDistinctSymbols()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, node.getHashSymbol(), Optional.empty()));
        }
        return Rule.Result.empty();
    }
}

